<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * Amounts Controller
 *
 * @property \App\Model\Table\AmountsTable $Amounts
 */
class AmountsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Amounts->find();
        $amounts = $this->paginate($query);

        $this->set(compact('amounts'));
    }

    /**
     * View method
     *
     * @param string|null $id Amount id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $amount = $this->Amounts->get($id, contain: []);
        $this->set(compact('amount'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $amount = $this->Amounts->newEmptyEntity();
        if ($this->request->is('post')) {
            $amount = $this->Amounts->patchEntity($amount, $this->request->getData());
            if ($this->Amounts->save($amount)) {
                $this->Flash->success(__('The amount has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The amount could not be saved. Please, try again.'));
        }
        $this->set(compact('amount'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Amount id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $amount = $this->Amounts->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $amount = $this->Amounts->patchEntity($amount, $this->request->getData());
            if ($this->Amounts->save($amount)) {
                $this->Flash->success(__('The amount has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The amount could not be saved. Please, try again.'));
        }
        $this->set(compact('amount'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Amount id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $amount = $this->Amounts->get($id);
        if ($this->Amounts->delete($amount)) {
            $this->Flash->success(__('The amount has been deleted.'));
        } else {
            $this->Flash->error(__('The amount could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
