<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * EventCosts Controller
 *
 * @property \App\Model\Table\EventCostsTable $EventCosts
 */
class EventCostsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->EventCosts->find()
            ->contain(['Events']);
        $eventCosts = $this->paginate($query);

        $this->set(compact('eventCosts'));
    }

    /**
     * View method
     *
     * @param string|null $id Event Cost id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $eventCost = $this->EventCosts->get($id, contain: ['Events', 'Registrations', 'Tickets']);
        $this->set(compact('eventCost'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $eventCost = $this->EventCosts->newEmptyEntity();
        if ($this->request->is('post')) {
            $eventCost = $this->EventCosts->patchEntity($eventCost, $this->request->getData());
            if ($this->EventCosts->save($eventCost)) {
                $this->Flash->success(__('The event cost has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The event cost could not be saved. Please, try again.'));
        }
        $events = $this->EventCosts->Events->find('list', limit: 200)->all();
        $this->set(compact('eventCost', 'events'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Event Cost id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $eventCost = $this->EventCosts->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $eventCost = $this->EventCosts->patchEntity($eventCost, $this->request->getData());
            if ($this->EventCosts->save($eventCost)) {
                $this->Flash->success(__('The event cost has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The event cost could not be saved. Please, try again.'));
        }
        $events = $this->EventCosts->Events->find('list', limit: 200)->all();
        $this->set(compact('eventCost', 'events'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Event Cost id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $eventCost = $this->EventCosts->get($id);
        if ($this->EventCosts->delete($eventCost)) {
            $this->Flash->success(__('The event cost has been deleted.'));
        } else {
            $this->Flash->error(__('The event cost could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
