<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * GolfSettings Controller
 *
 * @property \App\Model\Table\GolfSettingsTable $GolfSettings
 */
class GolfSettingsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->GolfSettings->find()->first();

        if ($query) {
            $this->redirect(['action' => 'edit', $query->id]);
        } else {
            $this->redirect(['action' => 'add']);
        }
    }

    /**
     * View method
     *
     * @param string|null $id Golf Setting id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $golfSetting = $this->GolfSettings->get($id, contain: []);
        $this->set(compact('golfSetting'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $golfSetting = $this->GolfSettings->newEmptyEntity();
        if ($this->request->is('post')) {
            $golfSetting = $this->GolfSettings->patchEntity($golfSetting, $this->request->getData());
            if ($this->GolfSettings->save($golfSetting)) {
                $this->Flash->success(__('The golf setting has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf setting could not be saved. Please, try again.'));
        }
        $this->set(compact('golfSetting'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Golf Setting id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $golfSetting = $this->GolfSettings->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $golfSetting = $this->GolfSettings->patchEntity($golfSetting, $this->request->getData());
            if ($this->GolfSettings->save($golfSetting)) {
                $this->Flash->success(__('The golf setting has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf setting could not be saved. Please, try again.'));
        }
        $this->set(compact('golfSetting'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Golf Setting id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $golfSetting = $this->GolfSettings->get($id);
        if ($this->GolfSettings->delete($golfSetting)) {
            $this->Flash->success(__('The golf setting has been deleted.'));
        } else {
            $this->Flash->error(__('The golf setting could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
