<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * GolfSponsorships Controller
 *
 * @property \App\Model\Table\GolfSponsorshipsTable $GolfSponsorships
 */
class GolfSponsorshipsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->GolfSponsorships->find();
        $golfSponsorships = $this->paginate($query);

        $this->set(compact('golfSponsorships'));
    }

    /**
     * View method
     *
     * @param string|null $id Golf Sponsorship id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $golfSponsorship = $this->GolfSponsorships->get($id, contain: []);
        $this->set(compact('golfSponsorship'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $golfSponsorship = $this->GolfSponsorships->newEmptyEntity();
        if ($this->request->is('post')) {
            $golfSponsorship = $this->GolfSponsorships->patchEntity($golfSponsorship, $this->request->getData());
            if ($this->GolfSponsorships->save($golfSponsorship)) {
                $this->Flash->success(__('The golf sponsorship has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf sponsorship could not be saved. Please, try again.'));
        }
        $this->set(compact('golfSponsorship'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Golf Sponsorship id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $golfSponsorship = $this->GolfSponsorships->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $golfSponsorship = $this->GolfSponsorships->patchEntity($golfSponsorship, $this->request->getData());
            if ($this->GolfSponsorships->save($golfSponsorship)) {
                $this->Flash->success(__('The golf sponsorship has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf sponsorship could not be saved. Please, try again.'));
        }
        $this->set(compact('golfSponsorship'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Golf Sponsorship id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $golfSponsorship = $this->GolfSponsorships->get($id);
        if ($this->GolfSponsorships->delete($golfSponsorship)) {
            $this->Flash->success(__('The golf sponsorship has been deleted.'));
        } else {
            $this->Flash->error(__('The golf sponsorship could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
