<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * Golfs Controller
 *
 * @property \App\Model\Table\GolfsTable $Golfs
 */
class GolfsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Golfs
            ->find()
            ->contain(['GolfTypes', 'GolfPlayers'])
            ->orderByDesc('Golfs.created');
        $golfs = $this->paginate($query);

        $this->set(compact('golfs'));
    }

    /**
     * View method
     *
     * @param string|null $id Golf id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $golf = $this->Golfs->get($id, contain: ['GolfTypes', 'GolfPlayers']);
        $this->set(compact('golf'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $golf = $this->Golfs->newEmptyEntity();
        if ($this->request->is('post')) {
            $golf = $this->Golfs->patchEntity($golf, $this->request->getData());
            if ($this->Golfs->save($golf)) {
                $this->Flash->success(__('The golf has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf could not be saved. Please, try again.'));
        }
        $golfTypes = $this->Golfs->GolfTypes->find('list', limit: 200)->all();
        $this->set(compact('golf', 'golfTypes'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Golf id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $golf = $this->Golfs->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $golf = $this->Golfs->patchEntity($golf, $this->request->getData());
            if ($this->Golfs->save($golf)) {
                $this->Flash->success(__('The golf has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf could not be saved. Please, try again.'));
        }
        $golfTypes = $this->Golfs->GolfTypes->find('list', limit: 200)->all();
        $this->set(compact('golf', 'golfTypes'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Golf id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $golf = $this->Golfs->get($id);
        if ($this->Golfs->delete($golf)) {
            $this->Flash->success(__('The golf has been deleted.'));
        } else {
            $this->Flash->error(__('The golf could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function csv()
    {
        $golfs = $this->Golfs
            ->find()
            ->contain(['GolfTypes', 'GolfPlayers' => ['Titles', 'Countries']])
            ->all();

        $header = [
            'Date',
            'Type',
            'Amount',
            'Paid',
            'Heard about',
            'Heard about other',
            'Tx. Status',
            'Tx. Detail',
            'Tx. code',
            'SagePay ID',
            'Card type',
            'Card Last digits',
            'Title',
            'Title Other',
            'Name',
            'Surname',
            'Address 1',
            'Address2',
            'City',
            'County',
            'Postal Code',
            'Country',
            'Telephone',
            'Mobile phone',
            'Email',
            'Can contact by email',
            'Can contact by phone',
            'Can contact by letter',
            'Title',
            'Title Other',
            'Name',
            'Surname',
            'Address 1',
            'Address2',
            'City',
            'County',
            'Postal Code',
            'Country',
            'Telephone',
            'Mobile phone',
            'Email',
            'Can contact by email',
            'Can contact by phone',
            'Can contact by letter',
            'Title',
            'Title Other',
            'Name',
            'Surname',
            'Address 1',
            'Address2',
            'City',
            'County',
            'Postal Code',
            'Country',
            'Telephone',
            'Mobile phone',
            'Email',
            'Can contact by email',
            'Can contact by phone',
            'Can contact by letter',
            'Title',
            'Title Other',
            'Name',
            'Surname',
            'Address 1',
            'Address2',
            'City',
            'County',
            'Postal Code',
            'Country',
            'Telephone',
            'Mobile phone',
            'Email',
            'Can contact by email',
            'Can contact by phone',
            'Can contact by letter',
        ];

        // header('Content-Type: text/csv; charset=utf-8');
        // header('Content-Disposition: attachment; filename=golfs-' . date('Y-m-d-h-i-s') . '.csv');
        $csv = fopen('php://temp/maxmemory:' . 5 * 1024 * 1024, 'r+');

        fputcsv($csv, $header);

        foreach ($golfs as $reg) {
            $row = [
                $reg->created->format('Y-m-d H:i:s'),
                str_replace('&pound;', 'GBP ', $reg->golf_type->name),
                $reg->amount,
                $reg->paid ? 'Yes' : 'No',
                $reg->heard_about,
                $reg->heard_about_other,
                $reg->tx_status,
                $reg->tx_status_detail,
                $reg->tx_code,
                $reg->tx_sagepay_id,
                $reg->tx_cardtype,
                $reg->tx_card_lastdigits,
            ];
            foreach ($reg->golf_players as $p) {
                $row = array_merge($row, [
                    $p->title->name,
                    $p->title_other,
                    $p->first_name,
                    $p->surname,
                    $p->address_1,
                    $p->address_2,
                    $p->city,
                    $p->county,
                    $p->postal_code,
                    $p->country->name,
                    $p->telephone,
                    $p->mobile_phone,
                    $p->email,
                    $p->optin_email ? 'Yes' : 'No',
                    $p->optin_telephone ? 'Yes' : 'No',
                    $p->optin_letter ? 'Yes' : 'No',
                ]);
            }

            fputcsv($csv, $row);
        }

        rewind($csv);
        $output = stream_get_contents($csv);

        $response = $this->response;
        $response = $response->withStringBody($output);
        $response = $response->withType('csv');
        $response = $response->withDownload('golfs-' . date('Y-m-d-h-i-s') . '.csv');
        return $response;
    }
}
