<?php
namespace App\Controller\Component;

use Cake\Controller\Component;
use Cake\Core\Configure;
use Cake\Routing\Router;

class SagePayComponent extends Component
{
    function buildCrypt($d)
    {
        Configure::load('payments');
        $trans_mode = Configure::read('Forms.SagePay.trans_mode');

        $intRandNum = rand(0, 32000) * rand(0, 32000);
        $strVendorTxCode = Configure::read('Forms.SagePay.vendor_name') . $intRandNum;
        $strPost = 'VendorTxCode=' . $strVendorTxCode;

        $strPost = $strPost . '&Amount=' . number_format($d->donation_amount, 2); // Formatted to 2 decimal places with leading digit
        $strPost = $strPost . '&Currency=' . Configure::read('Forms.SagePay.currency');
        // Up to 100 chars of free format description
        $strPost = $strPost . '&Description=' . Configure::read('Forms.SagePay.item_description.donations');

        //$url = "http://localhost/donation/donations/transaction_result/" . $d->id'];
        $url = Router::url(['controller' => 'donations', 'action' => 'transaction_result'], true);

        /* The SuccessURL is the page to which Form returns the customer if the transaction is successful
         ** You can change this for each transaction, perhaps passing a session ID or state flag if you wish */
        $strPost = $strPost . '&SuccessURL=' . $url;

        /* The FailureURL is the page to which Form returns the customer if the transaction is unsuccessful
         ** You can change this for each transaction, perhaps passing a session ID or state flag if you wish */
        $strPost = $strPost . '&FailureURL=' . $url;

        // This is an Optional setting. Here we are just using the Billing names given.
        $strPost = $strPost . '&CustomerName=' . $d->first_name . ' ' . $d->surname;

        /* Email settings:
         ** Flag 'SendEMail' is an Optional setting.
         ** 0 = Do not send either customer or vendor e-mails,
         ** 1 = Send customer and vendor e-mails if address(es) are provided(DEFAULT).
         ** 2 = Send Vendor Email but not Customer Email. If you do not supply this field, 1 is assumed and e-mails are sent if addresses are provided. **/
        $strPost = $strPost . '&SendEMail=1';

        if (strlen($d->email) > 0) {
            $strPost = $strPost . '&CustomerEMail=' . $d->email;
        } // This is an Optional setting

        $strPost = $strPost . '&VendorEMail=' . Configure::read('Forms.SagePay.vendor_email'); // This is an Optional setting

        // You can specify any custom message to send to your customers in their confirmation e-mail here
        // The field can contain HTML if you wish, and be different for each order.  This field is optional
        $strPost = $strPost . '&eMailMessage=' . Configure::read('Forms.SagePay.email_message.donations');

        // Billing Details:
        $strPost = $strPost . '&BillingFirstnames=' . $d->first_name;
        $strPost = $strPost . '&BillingSurname=' . $d->surname;
        $strPost = $strPost . '&BillingAddress1=' . $d->address_1;
        if (strlen($d->address_2) > 0) {
            $strPost = $strPost . '&BillingAddress2=' . $d->address_2;
        }
        $strPost = $strPost . '&BillingCity=' . $d->city;
        $strPost = $strPost . '&BillingPostCode=' . $d->postal_code;
        $strPost = $strPost . '&BillingCountry=' . $d->country->iso_code;
        if (strlen($d->state_code) > 0 && $d->country->name == 'United States') {
            $strPost = $strPost . '&BillingState=' . $d->state_code;
        }
        if (strlen($d->telephone) > 0) {
            $strPost = $strPost . '&BillingPhone=' . $d->telephone;
        }

        // Delivery Details:
        $strPost = $strPost . '&DeliveryFirstnames=' . $d->first_name;
        $strPost = $strPost . '&DeliverySurname=' . $d->surname;
        $strPost = $strPost . '&DeliveryAddress1=' . $d->address_1;
        if (strlen($d->address_2) > 0) {
            $strPost = $strPost . '&DeliveryAddress2=' . $d->address_2;
        }
        $strPost = $strPost . '&DeliveryCity=' . $d->city;
        $strPost = $strPost . '&DeliveryPostCode=' . $d->postal_code;
        $strPost = $strPost . '&DeliveryCountry=' . $d->country->iso_code;
        if (strlen($d->state_code) > 0 && $d->country_name == 'United States') {
            $strPost = $strPost . '&DeliveryState=' . $d->state_code;
        }
        if (strlen($d->telephone) > 0) {
            $strPost = $strPost . '&DeliveryPhone=' . $d->telephone;
        }

        //$strPost=$strPost . "&Basket=Donation to Martha Trust"; // As created above
        // For charities registered for Gift Aid, set to 1 to display the Gift Aid check box on the payment pages
        $strPost = $strPost . '&AllowGiftAid=1';
        // $strCrypt = $this->base64Encode($this->SimpleXor($strPost, Configure::read('encryption_' . Configure::read('trans_mode'))));
        // parse_str($strPost, $test); debug($test); exit;
        $strCrypt = mcrypt_encrypt(
            MCRYPT_RIJNDAEL_128,
            Configure::read('Forms.SagePay.encryption'),
            self::_pkcs5_pad($strPost),
            MCRYPT_MODE_CBC,
            Configure::read('Forms.SagePay.encryption'),
        );
        $anothercrypt = '@' . bin2hex($strCrypt);
        return $anothercrypt;
    }

    private static function _pkcs5_pad($text)
    {
        // $blocksize = mcrypt_get_block_size('des', 'cbc');
        $blocksize = 16;
        $pad = $blocksize - (strlen($text) % $blocksize);
        return $text . str_repeat(chr($pad), $pad);
    }
}
?>
