<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Ticket Entity
 *
 * @property int $id
 * @property int $registration_id
 * @property int $event_cost_id
 * @property int $amount
 *
 * @property \App\Model\Entity\Registration $registration
 * @property \App\Model\Entity\EventCost $event_cost
 */
class Ticket extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'registration_id' => true,
        'event_cost_id' => true,
        'amount' => true,
        'registration' => true,
        'event_cost' => true,
    ];

    public function subTotal() {
        return $this->amount * $this->event_cost->price;
    }
}
