<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cars Model
 *
 * @property \App\Model\Table\CarPartsTable&\Cake\ORM\Association\HasMany $CarParts
 *
 * @method \App\Model\Entity\Car newEmptyEntity()
 * @method \App\Model\Entity\Car newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Car[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Car get($primaryKey, $options = [])
 * @method \App\Model\Entity\Car findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Car patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Car[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Car|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Car saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Car[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Car[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Car[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Car[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class CarsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('cars');
        $this->setDisplayField('payment');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('CarParts', [
            'foreignKey' => 'car_id',
            'saveStrategy' => 'replace',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('payment')
            ->maxLength('payment', 255)
            ->requirePresence('payment', 'create')
            ->notEmptyString('payment');

        $validator
            ->integer('team_number')
            ->requirePresence('team_number', 'create')
            ->notEmptyString('team_number');

        $validator->boolean('tcs1')->notEmptyString('tcs1');

        $validator->boolean('tcs2')->notEmptyString('tcs2');

        $validator->boolean('tcs3')->notEmptyString('tcs3');

        $validator->boolean('tcs4')->notEmptyString('tcs4');

        $validator->boolean('is_mail_sent')->notEmptyString('is_mail_sent');

        $validator
            ->scalar('decline_code')
            ->maxLength('decline_code', 255)
            ->allowEmptyString('decline_code');

        $validator
            ->scalar('expiry_date')
            ->maxLength('expiry_date', 255)
            ->allowEmptyString('expiry_date');

        $validator
            ->scalar('bank_auth_code')
            ->maxLength('bank_auth_code', 255)
            ->allowEmptyString('bank_auth_code');

        $validator->boolean('paid')->notEmptyString('paid');

        $validator->boolean('agree1')->notEmptyString('agree1');

        $validator->boolean('agree2')->notEmptyString('agree2');

        $validator->boolean('agree3')->notEmptyString('agree3');

        $validator->boolean('agree4')->notEmptyString('agree4');

        $validator->boolean('agree5')->notEmptyString('agree5');

        $validator->boolean('agree6')->notEmptyString('agree6');

        $validator->boolean('agree7')->notEmptyString('agree7');

        $validator
            ->scalar('heard_about')
            ->maxLength('heard_about', 255)
            ->requirePresence('heard_about', 'create')
            ->notEmptyString('heard_about');

        return $validator;
    }

    public function beforeSave($event, $entity, $options)
    {
        if (count($entity['car_parts']) > $entity['team_number']) {
            $entity['car_parts'] = array_slice($entity['car_parts'], 0, $entity['team_number']);
        }
    }
}
