<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * GolfSponsorships Model
 *
 * @method \App\Model\Entity\GolfSponsorship newEmptyEntity()
 * @method \App\Model\Entity\GolfSponsorship newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\GolfSponsorship[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\GolfSponsorship get($primaryKey, $options = [])
 * @method \App\Model\Entity\GolfSponsorship findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\GolfSponsorship patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\GolfSponsorship[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\GolfSponsorship|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfSponsorship saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfSponsorship[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfSponsorship[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfSponsorship[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfSponsorship[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class GolfSponsorshipsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('golf_sponsorships');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 200)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        return $validator;
    }
}
