<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * GolfTypes Model
 *
 * @property \App\Model\Table\GolfsTable&\Cake\ORM\Association\HasMany $Golfs
 *
 * @method \App\Model\Entity\GolfType newEmptyEntity()
 * @method \App\Model\Entity\GolfType newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\GolfType[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\GolfType get($primaryKey, $options = [])
 * @method \App\Model\Entity\GolfType findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\GolfType patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\GolfType[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\GolfType|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfType saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfType[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfType[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfType[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfType[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class GolfTypesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('golf_types');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->hasMany('Golfs', [
            'foreignKey' => 'golf_type_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 255)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->decimal('price')
            ->requirePresence('price', 'create')
            ->notEmptyString('price');

        $validator
            ->integer('players')
            ->requirePresence('players', 'create')
            ->notEmptyString('players');

        return $validator;
    }
}
