<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Orders Model
 *
 * @property \App\Model\Table\TitlesTable&\Cake\ORM\Association\BelongsTo $Titles
 * @property \App\Model\Table\CountriesTable&\Cake\ORM\Association\BelongsTo $Countries
 * @property \App\Model\Table\OrderItemsTable&\Cake\ORM\Association\HasMany $OrderItems
 *
 * @method \App\Model\Entity\Order newEmptyEntity()
 * @method \App\Model\Entity\Order newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Order[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Order get($primaryKey, $options = [])
 * @method \App\Model\Entity\Order findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Order patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Order[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Order|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Order saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Order[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Order[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Order[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Order[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class OrdersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('orders');
        $this->setDisplayField('title_other');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Titles', [
            'foreignKey' => 'title_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsTo('DeliveryTitles', [
            'foreignKey' => 'd_title_id',
            'joinType' => 'INNER',
            'table' => 'titles',
            'className' => 'Titles',
        ]);

        $this->belongsTo('Countries', [
            'foreignKey' => 'country_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsTo('DeliveryCountries', [
            'foreignKey' => 'd_country_id',
            'joinType' => 'INNER',
            'table' => 'countries',
            'className' => 'Countries',
        ]);

        $this->hasMany('OrderItems', [
            'foreignKey' => 'order_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator->boolean('paid')->notEmptyString('paid');

        $validator->integer('title_id')->notEmptyString('title_id');

        $validator
            ->scalar('first_name')
            ->maxLength('first_name', 255)
            ->requirePresence('first_name', 'create')
            ->notEmptyString('first_name');

        $validator
            ->scalar('surname')
            ->maxLength('surname', 255)
            ->requirePresence('surname', 'create')
            ->notEmptyString('surname');

        $validator
            ->scalar('address_1')
            ->maxLength('address_1', 255)
            ->requirePresence('address_1', 'create')
            ->notEmptyString('address_1');

        $validator
            ->scalar('city')
            ->maxLength('city', 255)
            ->requirePresence('city', 'create')
            ->notEmptyString('city');

        $validator
            ->scalar('county')
            ->maxLength('county', 255)
            ->requirePresence('county', 'create')
            ->notEmptyString('county');

        $validator
            ->scalar('postal_code')
            ->maxLength('postal_code', 255)
            ->requirePresence('postal_code', 'create')
            ->notEmptyString('postal_code');

        $validator->integer('country_id')->notEmptyString('country_id');

        $validator
            ->email('email')
            ->requirePresence('email', 'create')
            ->notEmptyString('email');

        $validator
            ->scalar('email_confirm')
            ->maxLength('email_confirm', 255)
            ->requirePresence('email_confirm', 'create')
            ->notEmptyString('email_confirm');

        $validator->add('email_confirm', 'compareWith', [
            'rule' => ['compareWith', 'email'],
            'message' => 'Email addresses do not match',
        ]);

        $validator
            ->scalar('telephone')
            ->maxLength('telephone', 255)
            ->requirePresence('telephone', 'create')
            ->notEmptyString('telephone');

        $validator
            ->integer('d_title_id')
            ->requirePresence('d_title_id', 'create')
            ->notEmptyString('d_title_id');

        $validator
            ->scalar('d_first_name')
            ->maxLength('d_first_name', 255)
            ->requirePresence('d_first_name', 'create')
            ->notEmptyString('d_first_name');

        $validator
            ->scalar('d_surname')
            ->maxLength('d_surname', 255)
            ->requirePresence('d_surname', 'create')
            ->notEmptyString('d_surname');

        $validator
            ->scalar('d_address_1')
            ->maxLength('d_address_1', 255)
            ->requirePresence('d_address_1', 'create')
            ->notEmptyString('d_address_1');

        $validator
            ->scalar('d_city')
            ->maxLength('d_city', 255)
            ->requirePresence('d_city', 'create')
            ->notEmptyString('d_city');

        $validator
            ->scalar('d_county')
            ->maxLength('d_county', 255)
            ->requirePresence('d_county', 'create')
            ->notEmptyString('d_county');

        $validator
            ->scalar('d_postal_code')
            ->maxLength('d_postal_code', 255)
            ->requirePresence('d_postal_code', 'create')
            ->notEmptyString('d_postal_code');

        $validator->boolean('no_email')->notEmptyString('no_email');

        $validator->boolean('no_telephone')->notEmptyString('no_telephone');

        $validator->boolean('no_letter')->notEmptyString('no_letter');

        $validator
            ->integer('d_country_id')
            ->requirePresence('d_country_id', 'create')
            ->notEmptyString('d_country_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('title_id', 'Titles'), ['errorField' => 'title_id']);
        $rules->add($rules->existsIn('country_id', 'Countries'), ['errorField' => 'country_id']);

        return $rules;
    }
}
