<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Amount $amount
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Amount'), ['action' => 'edit', $amount->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Amount'), ['action' => 'delete', $amount->id], ['confirm' => __('Are you sure you want to delete # {0}?', $amount->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Amounts'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Amount'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="amounts view content">
            <h3><?= h($amount->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($amount->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($amount->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Amount') ?></th>
                    <td><?= $this->Number->format($amount->amount) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
