<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\CarPart> $carParts
 */
?>
<div class="carParts index content">
    <?= $this->Html->link(__('New Car Part'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Car Parts') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('car_id') ?></th>
                    <th><?= $this->Paginator->sort('title_id') ?></th>
                    <th><?= $this->Paginator->sort('title_other') ?></th>
                    <th><?= $this->Paginator->sort('first_name') ?></th>
                    <th><?= $this->Paginator->sort('surname') ?></th>
                    <th><?= $this->Paginator->sort('organisation') ?></th>
                    <th><?= $this->Paginator->sort('address_1') ?></th>
                    <th><?= $this->Paginator->sort('address_2') ?></th>
                    <th><?= $this->Paginator->sort('city') ?></th>
                    <th><?= $this->Paginator->sort('county') ?></th>
                    <th><?= $this->Paginator->sort('postal_code') ?></th>
                    <th><?= $this->Paginator->sort('country_id') ?></th>
                    <th><?= $this->Paginator->sort('state_code') ?></th>
                    <th><?= $this->Paginator->sort('email') ?></th>
                    <th><?= $this->Paginator->sort('email_confirm') ?></th>
                    <th><?= $this->Paginator->sort('telephone') ?></th>
                    <th><?= $this->Paginator->sort('mobile_phone') ?></th>
                    <th><?= $this->Paginator->sort('no_email') ?></th>
                    <th><?= $this->Paginator->sort('no_telephone') ?></th>
                    <th><?= $this->Paginator->sort('no_letter') ?></th>
                    <th><?= $this->Paginator->sort('optin_email') ?></th>
                    <th><?= $this->Paginator->sort('optin_telephone') ?></th>
                    <th><?= $this->Paginator->sort('optin_letter') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('modified') ?></th>
                    <th><?= $this->Paginator->sort('date_of_birth') ?></th>
                    <th><?= $this->Paginator->sort('dietary') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($carParts as $carPart): ?>
                <tr>
                    <td><?= $this->Number->format($carPart->id) ?></td>
                    <td><?= $carPart->hasValue('car') ? $this->Html->link($carPart->car->payment, ['controller' => 'Cars', 'action' => 'view', $carPart->car->id]) : '' ?></td>
                    <td><?= $carPart->hasValue('title') ? $this->Html->link($carPart->title->name, ['controller' => 'Titles', 'action' => 'view', $carPart->title->id]) : '' ?></td>
                    <td><?= h($carPart->title_other) ?></td>
                    <td><?= h($carPart->first_name) ?></td>
                    <td><?= h($carPart->surname) ?></td>
                    <td><?= h($carPart->organisation) ?></td>
                    <td><?= h($carPart->address_1) ?></td>
                    <td><?= h($carPart->address_2) ?></td>
                    <td><?= h($carPart->city) ?></td>
                    <td><?= h($carPart->county) ?></td>
                    <td><?= h($carPart->postal_code) ?></td>
                    <td><?= $carPart->hasValue('country') ? $this->Html->link($carPart->country->name, ['controller' => 'Countries', 'action' => 'view', $carPart->country->id]) : '' ?></td>
                    <td><?= h($carPart->state_code) ?></td>
                    <td><?= h($carPart->email) ?></td>
                    <td><?= h($carPart->email_confirm) ?></td>
                    <td><?= h($carPart->telephone) ?></td>
                    <td><?= h($carPart->mobile_phone) ?></td>
                    <td><?= h($carPart->no_email) ?></td>
                    <td><?= h($carPart->no_telephone) ?></td>
                    <td><?= h($carPart->no_letter) ?></td>
                    <td><?= h($carPart->optin_email) ?></td>
                    <td><?= h($carPart->optin_telephone) ?></td>
                    <td><?= h($carPart->optin_letter) ?></td>
                    <td><?= h($carPart->created) ?></td>
                    <td><?= h($carPart->modified) ?></td>
                    <td><?= h($carPart->date_of_birth) ?></td>
                    <td><?= h($carPart->dietary) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $carPart->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $carPart->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $carPart->id], ['confirm' => __('Are you sure you want to delete # {0}?', $carPart->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
