<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\CarSetting $carSetting
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Car Setting'), ['action' => 'edit', $carSetting->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Car Setting'), ['action' => 'delete', $carSetting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $carSetting->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Car Settings'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Car Setting'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="carSettings view content">
            <h3><?= h($carSetting->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Event Name') ?></th>
                    <td><?= h($carSetting->event_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Event Logo') ?></th>
                    <td><?= h($carSetting->event_logo) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($carSetting->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Event Year') ?></th>
                    <td><?= $carSetting->event_year === null ? '' : $this->Number->format($carSetting->event_year) ?></td>
                </tr>
                <tr>
                    <th><?= __('Registration Fee') ?></th>
                    <td><?= $carSetting->registration_fee === null ? '' : $this->Number->format($carSetting->registration_fee) ?></td>
                </tr>
                <tr>
                    <th><?= __('Minimum Sponsorship') ?></th>
                    <td><?= $carSetting->minimum_sponsorship === null ? '' : $this->Number->format($carSetting->minimum_sponsorship) ?></td>
                </tr>
                <tr>
                    <th><?= __('Interim Sponsorship') ?></th>
                    <td><?= $carSetting->interim_sponsorship === null ? '' : $this->Number->format($carSetting->interim_sponsorship) ?></td>
                </tr>
                <tr>
                    <th><?= __('Interim Fee Deadline') ?></th>
                    <td><?= h($carSetting->interim_fee_deadline) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Event Blurb') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($carSetting->event_blurb)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Last Checkbox Text') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($carSetting->last_checkbox_text)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Terms Conditions Text') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($carSetting->terms_conditions_text)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
