<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Donation> $donations
 */
?>
<div class="donations index content">
    <?= $this->Html->link(
        __('Download CSV'),
        ['action' => 'csv'],
        ['class' => 'button float-right', 'style' => 'margin-right: 5px;'],
    ) ?>
    <h3><?= __('Donations') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('first_name') ?></th>
                    <th><?= $this->Paginator->sort('surname') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th align="right"><?= $this->Paginator->sort('donation_amount') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($donations as $donation): ?>
                <tr>
                    <td><?= $this->Number->format($donation->id) ?></td>
                    <td><?= h($donation->first_name) ?></td>
                    <td><?= h($donation->surname) ?></td>
                    <td><?= h($donation->created) ?></td>
                    <td align="right">&pound;<?= $this->Number->format($donation->donation_amount, [
                        'places' => 2,
                        'precision' => 2,
                    ]) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $donation->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $donation->id]) ?>
                        <?= $this->Form->postLink(
                            __('Delete'),
                            ['action' => 'delete', $donation->id],
                            ['confirm' => __('Are you sure you want to delete # {0}?', $donation->id)],
                        ) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(
            __('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total'),
        ) ?></p>
    </div>
</div>