<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\EventCost> $eventCosts
 */
?>
<div class="eventCosts index content">
    <?= $this->Html->link(__('New Event Cost'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Event Costs') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('event_id') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('price') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($eventCosts as $eventCost): ?>
                <tr>
                    <td><?= $this->Number->format($eventCost->id) ?></td>
                    <td><?= $eventCost->hasValue('event') ? $this->Html->link($eventCost->event->name, ['controller' => 'Events', 'action' => 'view', $eventCost->event->id]) : '' ?></td>
                    <td><?= h($eventCost->name) ?></td>
                    <td><?= $this->Number->format($eventCost->price) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $eventCost->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $eventCost->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $eventCost->id], ['confirm' => __('Are you sure you want to delete # {0}?', $eventCost->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
