<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Event $event
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Events'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="events form content">
            <?= $this->Form->create($event) ?>
            <fieldset>
                <legend><?= __('Add Event') ?></legend>
                <?php
                echo $this->Form->control('name');
                echo $this->Form->control('event_date');
                echo $this->Form->control('participation_reasons_on');
                echo $this->Form->control('emergency_contact_on');
                echo $this->Form->control('custom_field_1');
                echo $this->Form->control('custom_field_2');
                echo $this->Form->control('email_text');
                echo $this->Form->control('active');
                echo $this->Form->control('multiple_tickets');
                echo $this->Form->control('dob_on');
                echo $this->Form->control('dob_text');
                echo $this->Form->control('terms_on');
                echo $this->Form->control('terms_text');
                ?>
            </fieldset>
            <fieldset>
                <h3>Event Costs</h3>

                <div class="row">
                    <div class="column column-40">Name</div>
                    <div class="column column-20">Price</div>
                    <div class="column column-20">Tickets available</div>
                    <div class="column column-20"></div>
                </div>

                <div class="row">
                    <div class="column">
                        <button id="add-cost" type="button" data-costs="0">Add event cost</button>
                    </div>
                </div>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>

<script type="text/javascript">
jQuery('#add-cost').on('click', function() {
    var costs = jQuery(this).data('costs');
    var html = `
        <div class="row">
            <div class="column column-40">
                <input type="hidden" name="event_costs[${costs}][id]" value="">
                <input type="text" name="event_costs[${costs}][name]" label="Name">
            </div>
            <div class="column column-20">
                <input type="text" name="event_costs[${costs}][price]" label="Price">
            </div>
            <div class="column column-20">
                <input type="text" name="event_costs[${costs}][tickets_available]" label="Available">
            </div>
            <div class="column column-20">
                <div style="height: 5px;">&nbsp;</div>
                <a href="#" class="remove-cost">Remove</a>
            </div>
        </div>
        `;
    jQuery(this).data('costs', costs + 1);
    jQuery(this).closest('fieldset').find('.row:last').before(html);
}).trigger('click');

jQuery('fieldset').on('click', '.remove-cost', function(e) {
    e.preventDefault();
    jQuery(this).closest('.row').remove();
});
</script>

<?php echo $this->Html->script(['https://code.jquery.com/jquery-3.7.1.min.js'], ['block' => 'script']); ?>