<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Event $event
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Event'), ['action' => 'edit', $event->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Event'), ['action' => 'delete', $event->id], ['confirm' => __('Are you sure you want to delete # {0}?', $event->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Events'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Event'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="events view content">
            <h3><?= h($event->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($event->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Custom Field 1') ?></th>
                    <td><?= h($event->custom_field_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Custom Field 2') ?></th>
                    <td><?= h($event->custom_field_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($event->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Event Date') ?></th>
                    <td><?= h($event->event_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Participation Reasons On') ?></th>
                    <td><?= $event->participation_reasons_on ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Emergency Contact On') ?></th>
                    <td><?= $event->emergency_contact_on ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Active') ?></th>
                    <td><?= $event->active ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Multiple Tickets') ?></th>
                    <td><?= $event->multiple_tickets ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Dob On') ?></th>
                    <td><?= $event->dob_on ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Terms On') ?></th>
                    <td><?= $event->terms_on ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Email Text') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($event->email_text)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Dob Text') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($event->dob_text)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Terms Text') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($event->terms_text)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Event Costs') ?></h4>
                <?php if (!empty($event->event_costs)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Event Id') ?></th>
                            <th><?= __('Name') ?></th>
                            <th><?= __('Tickets Available') ?></th>
                            <th align="right"><?= __('Price') ?></th>
                        </tr>
                        <?php foreach ($event->event_costs as $eventCosts) : ?>
                        <tr>
                            <td><?= h($eventCosts->id) ?></td>
                            <td><?= h($eventCosts->event_id) ?></td>
                            <td><?= h($eventCosts->name) ?></td>
                            <td><?= h($eventCosts->tickets_available) ?></td>
                            <td align="right">&pound;<?= h($eventCosts->price) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
