<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\GolfPlayer $golfPlayer
 * @var string[]|\Cake\Collection\CollectionInterface $golfs
 * @var string[]|\Cake\Collection\CollectionInterface $titles
 * @var string[]|\Cake\Collection\CollectionInterface $countries
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $golfPlayer->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $golfPlayer->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Golf Players'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfPlayers form content">
            <?= $this->Form->create($golfPlayer) ?>
            <fieldset>
                <legend><?= __('Edit Golf Player') ?></legend>
                <?php
                    echo $this->Form->control('golf_id', ['type' => 'hidden']);
                    echo $this->Form->control('title_id', ['options' => $titles]);
                    echo $this->Form->control('title_other');
                    echo $this->Form->control('first_name');
                    echo $this->Form->control('surname');
                    echo $this->Form->control('organisation');
                    echo $this->Form->control('address_1');
                    echo $this->Form->control('address_2');
                    echo $this->Form->control('city');
                    echo $this->Form->control('county');
                    echo $this->Form->control('postal_code');
                    echo $this->Form->control('country_id', ['options' => $countries]);
                    echo $this->Form->control('state_code');
                    echo $this->Form->control('email');
                    echo $this->Form->control('email_confirm');
                    echo $this->Form->control('telephone');
                    echo $this->Form->control('mobile_phone');
                    echo $this->Form->control('dietary_requirements');
                    echo $this->Form->control('no_email');
                    echo $this->Form->control('no_telephone');
                    echo $this->Form->control('no_letter');
                    echo $this->Form->control('optin_email');
                    echo $this->Form->control('optin_telephone');
                    echo $this->Form->control('optin_letter');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
