<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\GolfSetting $golfSetting
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Golf Setting'), ['action' => 'edit', $golfSetting->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Golf Setting'), ['action' => 'delete', $golfSetting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfSetting->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Golf Settings'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Golf Setting'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfSettings view content">
            <h3><?= h($golfSetting->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($golfSetting->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Blurb Top') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($golfSetting->blurb_top)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
