<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\GolfSponsorship> $golfSponsorships
 */
?>
<div class="golfSponsorships index content">
    <?= $this->Html->link(__('New Golf Sponsorship'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Golf Sponsorships') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($golfSponsorships as $golfSponsorship): ?>
                <tr>
                    <td><?= $this->Number->format($golfSponsorship->id) ?></td>
                    <td><?= h($golfSponsorship->name) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $golfSponsorship->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $golfSponsorship->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $golfSponsorship->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfSponsorship->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
