<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\GolfType $golfType
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $golfType->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $golfType->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Golf Types'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfTypes form content">
            <?= $this->Form->create($golfType) ?>
            <fieldset>
                <legend><?= __('Edit Golf Type') ?></legend>
                <?php
                    echo $this->Form->control('name');
                    echo $this->Form->control('price');
                    echo $this->Form->control('players');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
