<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Golf $golf
 * @var string[]|\Cake\Collection\CollectionInterface $golfTypes
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $golf->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $golf->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Golfs'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfs form content">
            <?= $this->Form->create($golf) ?>
            <fieldset>
                <legend><?= __('Edit Golf') ?></legend>
                <?php
                    echo $this->Form->control('amount');
                    echo $this->Form->control('golf_type_id', ['options' => $golfTypes]);
                    echo $this->Form->control('heard_about');
                    echo $this->Form->control('heard_about_other');
                    echo $this->Form->control('tx_status');
                    echo $this->Form->control('tx_status_detail');
                    echo $this->Form->control('tx_code');
                    echo $this->Form->control('tx_sagepay_id');
                    echo $this->Form->control('tx_cardtype');
                    echo $this->Form->control('tx_card_lastdigits');
                    echo $this->Form->control('is_mail_sent');
                    echo $this->Form->control('decline_code');
                    echo $this->Form->control('expiry_date');
                    echo $this->Form->control('bank_auth_code');
                    echo $this->Form->control('paid');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
