<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Light $light
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Light'), ['action' => 'edit', $light->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Light'), ['action' => 'delete', $light->id], ['confirm' => __('Are you sure you want to delete # {0}?', $light->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Lights'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="lights view content">
            <h3><?= h($light->homes) ?></h3>
            <table>
                <tr>
                    <th><?= __('Homes') ?></th>
                    <td><?= h($light->homes) ?></td>
                </tr>
                <tr>
                    <th><?= __('Gift Aid Understood') ?></th>
                    <td><?= $light->gift_aid_understood ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Gift Aid For') ?></th>
                    <td><?= h($light->gift_aid_for) ?></td>
                </tr>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= $light->hasValue('title') ? $this->Html->link($light->title->name, ['controller' => 'Titles', 'action' => 'view', $light->title->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Title Other') ?></th>
                    <td><?= h($light->title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('First Name') ?></th>
                    <td><?= h($light->first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Surname') ?></th>
                    <td><?= h($light->surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 1') ?></th>
                    <td><?= h($light->address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 2') ?></th>
                    <td><?= h($light->address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('City') ?></th>
                    <td><?= h($light->city) ?></td>
                </tr>
                <tr>
                    <th><?= __('County') ?></th>
                    <td><?= h($light->county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Postal Code') ?></th>
                    <td><?= h($light->postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Country') ?></th>
                    <td><?= $light->hasValue('country') ? $this->Html->link($light->country->name, ['controller' => 'Countries', 'action' => 'view', $light->country->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('State Code') ?></th>
                    <td><?= h($light->state_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($light->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email Confirm') ?></th>
                    <td><?= h($light->email_confirm) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($light->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile Phone') ?></th>
                    <td><?= h($light->mobile_phone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status') ?></th>
                    <td><?= h($light->tx_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status Detail') ?></th>
                    <td><?= h($light->tx_status_detail) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Code') ?></th>
                    <td><?= h($light->tx_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Sagepay Id') ?></th>
                    <td><?= h($light->tx_sagepay_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Cardtype') ?></th>
                    <td><?= h($light->tx_cardtype) ?></td>
                </tr>
                <tr>
                    <th><?= __('Decline Code') ?></th>
                    <td><?= h($light->decline_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Expiry Date') ?></th>
                    <td><?= h($light->expiry_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bank Auth Code') ?></th>
                    <td><?= h($light->bank_auth_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($light->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Donation Amount') ?></th>
                    <td><?= $this->Number->format($light->donation_amount) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Card Lastdigits') ?></th>
                    <td><?= $this->Number->format($light->tx_card_lastdigits) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($light->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($light->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('No Email') ?></th>
                    <td><?= $light->no_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Telephone') ?></th>
                    <td><?= $light->no_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Letter') ?></th>
                    <td><?= $light->no_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Email') ?></th>
                    <td><?= $light->optin_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Telephone') ?></th>
                    <td><?= $light->optin_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Letter') ?></th>
                    <td><?= $light->optin_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Mail Sent') ?></th>
                    <td><?= $light->is_mail_sent ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Message') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($light->message)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
