<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Order $order
 * @var string[]|\Cake\Collection\CollectionInterface $titles
 * @var string[]|\Cake\Collection\CollectionInterface $countries
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $order->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $order->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Orders'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="orders form content">
            <?= $this->Form->create($order) ?>
            <fieldset>
                <legend><?= __('Edit Order') ?></legend>
                <?php
                    echo $this->Form->control('amount');
                    echo $this->Form->control('paid');
                    echo $this->Form->control('title_id', ['options' => $titles]);
                    echo $this->Form->control('title_other');
                    echo $this->Form->control('first_name');
                    echo $this->Form->control('surname');
                    echo $this->Form->control('address_1');
                    echo $this->Form->control('address_2');
                    echo $this->Form->control('city');
                    echo $this->Form->control('county');
                    echo $this->Form->control('postal_code');
                    echo $this->Form->control('country_id', ['options' => $countries]);
                    echo $this->Form->control('email');
                    echo $this->Form->control('email_confirm');
                    echo $this->Form->control('telephone');
                    echo $this->Form->control('mobile_phone');
                    echo $this->Form->control('d_title_id', ['options' => $titles]);
                    echo $this->Form->control('d_title_other');
                    echo $this->Form->control('d_first_name');
                    echo $this->Form->control('d_surname');
                    echo $this->Form->control('d_address_1');
                    echo $this->Form->control('d_address_2');
                    echo $this->Form->control('d_city');
                    echo $this->Form->control('d_county');
                    echo $this->Form->control('d_postal_code');
                    echo $this->Form->control('d_country_id', ['options' => $countries]);
                    echo $this->Form->control('no_email');
                    echo $this->Form->control('no_telephone');
                    echo $this->Form->control('no_letter');
                    echo $this->Form->control('optin_email');
                    echo $this->Form->control('optin_telephone');
                    echo $this->Form->control('optin_letter');
                    echo $this->Form->control('tx_status');
                    echo $this->Form->control('tx_status_detail');
                    echo $this->Form->control('tx_code');
                    echo $this->Form->control('tx_sagepay_id');
                    echo $this->Form->control('tx_cardtype');
                    echo $this->Form->control('tx_card_lastdigits');
                    echo $this->Form->control('is_mail_sent');
                    echo $this->Form->control('decline_code');
                    echo $this->Form->control('expiry_date');
                    echo $this->Form->control('bank_auth_code');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
