<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Registration> $registrations
 */
?>
<div class="registrations index content">
    <?= $this->Html->link(
        __('Download CSV'),
        ['action' => 'csv', '?' => ['event_id' => $this->getRequest()->getQuery('event_id')]],
        ['class' => 'button float-right', 'style' => 'margin-right: 5px;'],
    ) ?>
    <h3><?= __('Registrations') ?></h3>
    <?php echo $this->Form->create(null, [
        'type' => 'get',
    ]); ?>
    <div class="row">
        <div class="column">
            <?php echo $this->Form->select('event_id', $events, [
                'empty' => '- Filter by event -',
                'val' => $this->getRequest()->getQuery('event_id'),
                'onchange' => 'this.form.submit()',
            ]); ?>

        </div>
        <div class="column">
            <?php
            echo $this->Form->submit('Filter');
            echo $this->Form->end();
            ?>
        </div>
    </div>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('event_id') ?></th>
                    <th><?= $this->Paginator->sort('amount') ?></th>
                    <th><?= $this->Paginator->sort('first_name') ?></th>
                    <th><?= $this->Paginator->sort('surname') ?></th>
                    <th><?= $this->Paginator->sort('email') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($registrations as $registration): ?>
                <tr>
                    <td><?= $this->Number->format($registration->id) ?></td>
                    <td><?= $registration->hasValue('event')
                        ? $this->Html->link($registration->event->name, [
                            'controller' => 'Events',
                            'action' => 'view',
                            $registration->event->id,
                        ])
                        : '' ?>
                    </td>
                    <td>&pound;<?= $this->Number->format($registration->amount, ['places' => 2]) ?></td>
                    <td><?= h($registration->first_name) ?></td>
                    <td><?= h($registration->surname) ?></td>
                    <td><?= h($registration->email) ?></td>
                    <td><?= h($registration->created) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $registration->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $registration->id]) ?>
                        <?= $this->Form->postLink(
                            __('Delete'),
                            ['action' => 'delete', $registration->id],
                            ['confirm' => __('Are you sure you want to delete # {0}?', $registration->id)],
                        ) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(
            __('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total'),
        ) ?>
        </p>
    </div>
</div>