<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Ticket $ticket
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Ticket'), ['action' => 'edit', $ticket->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Ticket'), ['action' => 'delete', $ticket->id], ['confirm' => __('Are you sure you want to delete # {0}?', $ticket->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Tickets'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Ticket'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="tickets view content">
            <h3><?= h($ticket->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Registration') ?></th>
                    <td><?= $ticket->hasValue('registration') ? $this->Html->link($ticket->registration->age_on_race, ['controller' => 'Registrations', 'action' => 'view', $ticket->registration->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Event Cost') ?></th>
                    <td><?= $ticket->hasValue('event_cost') ? $this->Html->link($ticket->event_cost->name, ['controller' => 'EventCosts', 'action' => 'view', $ticket->event_cost->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($ticket->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Amount') ?></th>
                    <td><?= $this->Number->format($ticket->amount) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
