<?php $this->Form->setTemplates([
    'inputContainer' =>
        '<div id="{{div_id}}" class="input {{type}}{{required}} {{extra_div_classes}}">{{before}} {{content}} {{after}}</div>',
    'input' => '{{between}} <input type="{{type}}" name="{{name}}"{{attrs}}/>',
]); ?>

<?php
$payments = [
    "I wish to pay our GBP {$car_settings->registration_fee} deposit online now" => "I wish to pay our &pound;{$car_settings->registration_fee} non-refundable registration fee online now",
    "I will pay our GBP {$car_settings->registration_fee} deposit later" => "I will pay our &pound;{$car_settings->registration_fee} non-refundable registration fee later",
];

$heard = [
    'Colleague' => 'Colleague',
    'Facebook' => 'Facebook',
    'Friends and Family' => 'Friends and Family',
    'Letter' => 'Letter',
    'Martha News' => 'Martha News',
    'Newspaper' => 'Newspaper',
    'Search engine' => 'Search engine',
    'Twitter' => 'Twitter',
    'Other' => 'Other',
];
?>

<?php $this->assign('title', 'Bonkers in Barcelona 2023 registration form'); ?>

<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your registration will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
); ?>

<h1><?php echo $car_settings->event_name; ?> <?php echo $car_settings->event_year; ?> registration form</h1>
<p>
    <?php echo $this->Html->image('cars/' . $car_settings->event_logo, [
        'width' => '260',
        'height' => '163',
        'alt' => 'Bonkers in Barcelona 2023',
        'title' => 'Bonkers in Barcelona 2023',
        'align' => 'right',
    ]); ?>
    <?php echo $car_settings->event_blurb; ?>
</p>
<div class="cars form">
    <?php
    echo $this->Form->create($car, ['id' => 'cars-registration-form']);
    echo $this->Form->control('id');
    ?>

    <?php
    echo $this->Form->control('agree1', [
        'label' => "I/we agree to pledge to raise a minimum sponsorship of &pound;{$car_settings->minimum_sponsorship} per two participants",
        'escape' => false,
        'data-required' => 'true',
    ]);
    echo $this->Form->control('agree6', [
        'label' => 'I/we agree to advise Martha Trust if we are struggling to raise sponsorship ',
        'escape' => false,
        'data-required' => 'true',
    ]);
    echo $this->Form->control('agree2', [
        'label' => 'I/we will ensure all sponsorship is paid to Martha Trust one calendar month after the event',
        'escape' => false,
        'data-required' => 'true',
    ]);
    echo $this->Form->control('agree3', [
        'label' =>
            "I/we agree to have paid &pound;{$car_settings->interim_sponsorship} of my total &pound;{$car_settings->minimum_sponsorship} sponsorship to Martha by " .
            date('jS F Y', strtotime($car_settings->interim_fee_deadline)) .
            " (the &pound;{$car_settings->interim_sponsorship} includes the &pound;{$car_settings->registration_fee} non-refundable registration fee)",
        'escape' => false,
        'data-required' => 'true',
    ]); //echo $this->Form->control('agree7', array('label' => 'I agree to have paid &pound;800 of my total &pound;1,500 sponsorship to Martha by the time we set off for Monte Carlo on 19th September (the &pound;800 includes the &pound;400 registration fee))'));
    echo $this->Form->control('agree4', [
        'label' =>
            'I/we will provide a mobile number to be added to a contacts list for all teams to access for the duration of the trip',
        'escape' => false,
        'data-required' => 'true',
    ]);
    echo $this->Form->control('agree5', [
        'label' => $car_settings->last_checkbox_text,
        'escape' => false,
        'data-required' => 'true',
    ]);
    ?>
    <fieldset>
        <h2>Payment of non-refundable registration fee (required)</h2>
        <?php
        echo $this->Form->control('id');
        echo $this->Form->control('payment', [
            'options' => $payments,
            'escape' => false,
            'type' => 'radio',
            'legend' => false,
            'label' => false,
            'default' => 'I wish to pay our GBP 400 deposit online now',
            'templateVars' => [
                'div_id' => 'cars-payment-div',
                'extra_div_classes' => 'full-labels',
            ],
        ]);
        ?>
    </fieldset>
    <fieldset>
        <h2>Team details</h2>
        <?php
        echo $this->Form->control('team_name', ['label' => 'Team name (if applicable)']);
        echo $this->Form->control('team_number', [
            'label' => 'Number of team members',
            'options' => [2 => 2, 3 => 3, 4 => 4],
            'type' => 'select',
        ]);
        echo $this->Form->control('car_theme', ['label' => 'Car theme (if applicable)']);
        echo $this->Form->control('contact_mobile', [
            'label' => 'Contact mobile number for this trip',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);

        echo $this->Form->control('heard_about', [
            'options' => $heard,
            'label' => 'Where did you hear about the Car Challenge?',
            'empty' => 'Please select...',
            'data-unhide-div' => '#heard-about-other-div',
            'data-unhide-text' => 'Other',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control('heard_about_other', [
            'label' => 'Other place you heard about the Car Challenge',
            'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => 'heard-about-other-div'],
        ]);
        ?>
    </fieldset>
    <?php for ($i = 0; $i < 4; $i++) { ?>
    <fieldset <?php echo $i > 1 ? ' class="hidden participants"' : ''; ?> id="part_<?php echo $i; ?>">
        <h2>Participant <?php echo $i + 1; ?> details <?php echo $i == 0 ? '(main contact)' : ''; ?></h2>
        <?php
        echo $this->Form->control("car_parts.{$i}.title_id", [
            'options' => $titles,
            'label' => 'Title',
            'class' => 'title_select',
            'data-unhide-div' => "#title-other-div-p{$i}",
            'data-unhide-text' => 'Other',
        ]);
        echo $this->Form->control("car_parts.{$i}.title_other", [
            'label' => 'Your title',
            'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => "title-other-div-p{$i}"],
        ]);

        echo $this->Form->control("car_parts.{$i}.first_name", [
            'label' => 'First name',
            'templateVars' => [
                'after' =>
                    '<span class="instructions">(required - please give your name as it appears on your passport)</span>',
            ],
        ]);
        echo $this->Form->control("car_parts.{$i}.surname", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Surname',
        ]);
        echo $this->Form->control("car_parts.{$i}.organisation", ['label' => 'Organisation (if applicable)']);
        echo $this->Form->control("car_parts.{$i}.address_1", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Address 1',
        ]);
        echo $this->Form->control("car_parts.{$i}.address_2", [
            'label' => 'Address 2',
        ]);
        echo $this->Form->control("car_parts.{$i}.city", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Town or city',
        ]);
        echo $this->Form->control("car_parts.{$i}.county", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'County',
        ]);
        echo $this->Form->control("car_parts.{$i}.postal_code", [
            'label' => 'Postcode',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control("car_parts.{$i}.country_id", ['default' => 77]);
        echo $this->Form->control("car_parts.{$i}.telephone", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Telephone',
        ]);
        echo $this->Form->control("car_parts.{$i}.mobile_phone", ['label' => 'Mobile']);
        echo $this->Form->control("car_parts.{$i}.email", [
            'label' => 'Email address',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control("car_parts.{$i}.email_confirm", [
            'label' => 'Confirm your email address',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);

        echo $this->Form->control("car_parts.{$i}.date_of_birth", [
            'label' => 'Your date of birth',
            'empty' => 'Select...',
            'dateFormat' => 'DMY',
            'minYear' => 1910,
            'maxYear' => 2002,
            'templateVars' => ['after' => '<span class="instructions">(required for booking flights)</span>'],
        ]);
        echo $this->Form->control("car_parts.{$i}.dietary", [
            'label' => 'Do you have any dietary requirements or allergies?',
        ]);
        ?>
        <p>Martha Trust would like to keep you updated on our future news, fundraising activities and ways to support
            us. To opt in to receiving information from Martha Trust, please tick how you would prefer to be contacted:
        </p>
        <?php
        echo $this->Form->control("car_parts.{$i}.optin_email", ['label' => 'Email']);
        echo $this->Form->control("car_parts.{$i}.optin_telephone", ['label' => 'Telephone']);
        echo $this->Form->control("car_parts.{$i}.optin_letter", ['label' => 'Letter']);
        ?>
        <p>or email <a href="mailto:fundraising@marthatrust.org.uk">fundraising@marthatrust.org.uk</a>.</p>
        <p>We do not sell or swap your details with any third parties, but in order to carry out our work we may need to
            pass your details to services companies authorised to act on our behalf.</p>
    </fieldset>
    <?php } ?>
    <h2>Terms and conditions</h2>
    <div class="whitespace">
        <p>
            <?php echo $car_settings->terms_conditions_text; ?>
        </p>
    </div>

    <?php
    echo $this->Form->control('tcs1', [
        'required' => true,
        'data-required' => 'true',
        'class' => 'terms-checkbox',
        'label' => 'Participant 1: I have read and agree to the terms and conditions',
        'templateVars' => ['extra_div_classes' => 'terms tcs1'],
    ]);
    echo $this->Form->control('tcs2', [
        'required' => true,
        'data-required' => 'true',
        'class' => 'terms-checkbox',
        'label' => 'Participant 2: I have read and agree to the terms and conditions',
        'templateVars' => ['extra_div_classes' => 'terms tcs2'],
    ]);
    echo $this->Form->control('tcs3', [
        'required' => true,
        'data-required' => 'true',
        'class' => 'terms-checkbox',
        'label' => 'Participant 3: I have read and agree to the terms and conditions',
        'templateVars' => ['extra_div_classes' => 'terms tcs3'],
    ]);
    echo $this->Form->control('tcs4', [
        'required' => true,
        'data-required' => 'true',
        'class' => 'terms-checkbox',
        'label' => 'Participant 4: I have read and agree to the terms and conditions',
        'templateVars' => ['extra_div_classes' => 'terms tcs4'],
    ]);

//echo $this->Form->control('tcs3', array('label' => 'Participant 3: I have read and agree to the terms and conditions', 'div' => array('class' => 'terms input checkbox')));
//echo $this->Form->control('tcs4', array('label' => 'Participant 4: I have read and agree to the terms and conditions', 'div' => array('class' => 'terms input checkbox')));
?>
    <fieldset>
        <?php echo $this->Recaptcha->display(); ?>
    </fieldset>
    <button type="button" id="cars-submit-button">Submit</button>
    <?php echo $this->Form->end(); ?>
</div>

<?php echo $this->Html->script(['https://code.jquery.com/jquery-3.7.1.min.js', 'application.js']); ?>
<?php echo $this->Html->css(['forms.css']);
