<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Donation> $donations
 */
?>
<div class="donations index content">
    <?= $this->Html->link(__('New Donation'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Donations') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('donation_amount') ?></th>
                    <th><?= $this->Paginator->sort('gift_aid_for') ?></th>
                    <th><?= $this->Paginator->sort('gift_aid_understood') ?></th>
                    <th><?= $this->Paginator->sort('title_id') ?></th>
                    <th><?= $this->Paginator->sort('title_other') ?></th>
                    <th><?= $this->Paginator->sort('first_name') ?></th>
                    <th><?= $this->Paginator->sort('surname') ?></th>
                    <th><?= $this->Paginator->sort('address_1') ?></th>
                    <th><?= $this->Paginator->sort('address_2') ?></th>
                    <th><?= $this->Paginator->sort('city') ?></th>
                    <th><?= $this->Paginator->sort('county') ?></th>
                    <th><?= $this->Paginator->sort('postal_code') ?></th>
                    <th><?= $this->Paginator->sort('country_id') ?></th>
                    <th><?= $this->Paginator->sort('state_code') ?></th>
                    <th><?= $this->Paginator->sort('email') ?></th>
                    <th><?= $this->Paginator->sort('email_confirm') ?></th>
                    <th><?= $this->Paginator->sort('telephone') ?></th>
                    <th><?= $this->Paginator->sort('mobile_phone') ?></th>
                    <th><?= $this->Paginator->sort('no_email') ?></th>
                    <th><?= $this->Paginator->sort('no_telephone') ?></th>
                    <th><?= $this->Paginator->sort('no_letter') ?></th>
                    <th><?= $this->Paginator->sort('optin_email') ?></th>
                    <th><?= $this->Paginator->sort('optin_telephone') ?></th>
                    <th><?= $this->Paginator->sort('optin_letter') ?></th>
                    <th><?= $this->Paginator->sort('tx_status') ?></th>
                    <th><?= $this->Paginator->sort('tx_status_detail') ?></th>
                    <th><?= $this->Paginator->sort('tx_code') ?></th>
                    <th><?= $this->Paginator->sort('tx_sagepay_id') ?></th>
                    <th><?= $this->Paginator->sort('tx_cardtype') ?></th>
                    <th><?= $this->Paginator->sort('tx_card_lastdigits') ?></th>
                    <th><?= $this->Paginator->sort('is_mail_sent') ?></th>
                    <th><?= $this->Paginator->sort('decline_code') ?></th>
                    <th><?= $this->Paginator->sort('expiry_date') ?></th>
                    <th><?= $this->Paginator->sort('bank_auth_code') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('modified') ?></th>
                    <th><?= $this->Paginator->sort('organisation') ?></th>
                    <th><?= $this->Paginator->sort('message') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($donations as $donation): ?>
                <tr>
                    <td><?= $this->Number->format($donation->id) ?></td>
                    <td><?= $this->Number->format($donation->donation_amount) ?></td>
                    <td><?= h($donation->gift_aid_for) ?></td>
                    <td><?= h($donation->gift_aid_understood) ?></td>
                    <td><?= $donation->hasValue('title') ? $this->Html->link($donation->title->name, ['controller' => 'Titles', 'action' => 'view', $donation->title->id]) : '' ?></td>
                    <td><?= h($donation->title_other) ?></td>
                    <td><?= h($donation->first_name) ?></td>
                    <td><?= h($donation->surname) ?></td>
                    <td><?= h($donation->address_1) ?></td>
                    <td><?= h($donation->address_2) ?></td>
                    <td><?= h($donation->city) ?></td>
                    <td><?= h($donation->county) ?></td>
                    <td><?= h($donation->postal_code) ?></td>
                    <td><?= $donation->hasValue('country') ? $this->Html->link($donation->country->name, ['controller' => 'Countries', 'action' => 'view', $donation->country->id]) : '' ?></td>
                    <td><?= h($donation->state_code) ?></td>
                    <td><?= h($donation->email) ?></td>
                    <td><?= h($donation->email_confirm) ?></td>
                    <td><?= h($donation->telephone) ?></td>
                    <td><?= h($donation->mobile_phone) ?></td>
                    <td><?= h($donation->no_email) ?></td>
                    <td><?= h($donation->no_telephone) ?></td>
                    <td><?= h($donation->no_letter) ?></td>
                    <td><?= h($donation->optin_email) ?></td>
                    <td><?= h($donation->optin_telephone) ?></td>
                    <td><?= h($donation->optin_letter) ?></td>
                    <td><?= h($donation->tx_status) ?></td>
                    <td><?= h($donation->tx_status_detail) ?></td>
                    <td><?= h($donation->tx_code) ?></td>
                    <td><?= h($donation->tx_sagepay_id) ?></td>
                    <td><?= h($donation->tx_cardtype) ?></td>
                    <td><?= $this->Number->format($donation->tx_card_lastdigits) ?></td>
                    <td><?= h($donation->is_mail_sent) ?></td>
                    <td><?= h($donation->decline_code) ?></td>
                    <td><?= h($donation->expiry_date) ?></td>
                    <td><?= h($donation->bank_auth_code) ?></td>
                    <td><?= h($donation->created) ?></td>
                    <td><?= h($donation->modified) ?></td>
                    <td><?= h($donation->organisation) ?></td>
                    <td><?= h($donation->message) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $donation->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $donation->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $donation->id], ['confirm' => __('Are you sure you want to delete # {0}?', $donation->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
