<?php use Cake\Core\Configure; ?>

<h1>Confirm your details</h1>

<?php $this->assign('title', 'Confirm the details of your registration'); ?>
<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your registration will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
); ?>

<p>Please check the details below to be sure they are correct. If you would like to change anything, you can
    <?php echo $this->Html->link('go back and make changes', ['action' => 'register']); ?>.
</p>

<table width="90%">
    <tr>
        <td colspan="100%"><strong>Your registration details</strong></td>
    </tr>
    <tr>
        <td>Registration type</td>
        <td><?php echo $golf->golf_type->name; ?></td>
    </tr>
    <tr>
        <td>Cost</td>
        <td>&pound;<?php echo $this->Number->format($golf->golf_type->price, ['places' => 2]); ?></td>
    </tr>
    <tr>
        <td>Heard about</td>
        <td><?php echo $golf->heard_about; ?></td>
    </tr>

    <?php if ($golf->heard_about == 'Other') { ?>
    <tr>
        <td>Heard about other</td>
        <td><?php echo $golf->heard_about_other; ?></td>
    </tr>
    <?php } ?>

    <?php
    $c = 0;
    foreach ($golf->golf_players as $p) {
        $c++; ?>
    <tr>
        <td colspan="100%"><strong>Player <?php echo $c; ?> details</strong></td>
    <tr>
        <td>Title</td>
        <td><?php echo $p->title->name; ?></td>
    </tr>
    <?php if ($p->title->name == 'Other') { ?>
    <tr>
        <td>Title (if Other)</td>
        <td><?php echo $p->title_other; ?></td>
    </tr>
    <?php } ?>

    <tr>
        <td>First name</td>
        <td><?php echo $p->first_name; ?></td>
    </tr>
    <tr>
        <td>Surname</td>
        <td><?php echo $p->surname; ?></td>
    </tr>
    <tr>
        <td>Address 1</td>
        <td><?php echo $p->address_1; ?></td>
    </tr>
    <tr>
        <td>Address 2</td>
        <td><?php echo $p->address_2; ?></td>
    </tr>
    <tr>
        <td>City</td>
        <td><?php echo $p->city; ?></td>
    </tr>
    <tr>
        <td>Postcode</td>
        <td><?php echo $p->postal_code; ?></td>
    </tr>
    <tr>
        <td>Country</td>
        <td><?php echo $p->country->name; ?></td>
    </tr>
    <tr>
        <td>Telephone</td>
        <td><?php echo $p->telephone; ?></td>
    </tr>
    <tr>
        <td>Mobile phone</td>
        <td><?php echo $p->mobile_phone; ?></td>
    </tr>
    <tr>
        <td>Email address</td>
        <td><?php echo $p->email; ?></td>
    </tr>
    <tr>
        <td>Dietary requirements</td>
        <td><?php echo $p->dietary_requirements; ?></td>
    </tr>
    <tr>
        <td>Contact by email</td>
        <td><?php echo $p->optin_email ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Contact by telephone</td>
        <td><?php echo $p->optin_telephone ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Contact by letter</td>
        <td><?php echo $p->optin_letter ? 'Yes' : 'No'; ?></td>
    </tr>
    <?php
    }
    ?>
</table>

<p>If you're happy with your registration details, please click Proceed to continue with your Golf Day registration:
</p>
<p>
<form action="<?php echo $sagepay_url; ?>" method="POST" id="SagePayForm" name="SagePayForm">
    <input type="hidden" name="VPSProtocol" value="3.00">
    <input type="hidden" name="TxType" value="PAYMENT">
    <input type="hidden" name="Vendor" value="<?php echo Configure::read('Forms.SagePay.vendor_name'); ?>">
    <input type="hidden" name="Crypt" value="<?php echo $crypted; ?>">
    <input type="submit" value="Proceed to payment" />
</form>
</p>