<?php $this->Form->setTemplates([
    'inputContainer' =>
        '<div id="{{div_id}}" class="input {{type}}{{required}} {{extra_div_classes}}">{{before}} {{content}} {{after}}</div>',
    'input' => '{{between}} <input type="{{type}}" name="{{name}}"{{attrs}}/>',
]); ?>

<?php
$this->assign('title', 'Golf Day registration form');
$heard = [
    'Colleague' => 'Colleague',
    'Facebook' => 'Facebook',
    'Friends and Family' => 'Friends and Family',
    'Letter' => 'Letter',
    'Martha News' => 'Martha News',
    'Newspaper' => 'Newspaper',
    'Search engine' => 'Search engine',
    'Twitter' => 'Twitter',
    'Other' => 'Other',
];
?>

<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your registration will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
); ?>

<h1>Golf Day registration form</h1>
<p><?php echo $golf_settings->blurb_top; ?></p>
<div class="golfs form">
    <?php echo $this->Form->create($golf, ['id' => 'golf-registration-form']); ?>
    <fieldset>
        <h2>Registration type</h2>
        <?php
        echo $this->Form->control('id');
        echo $this->Form->control('golf_type_id', [
            'label' => false,
            'type' => 'select',
            'options' => $golf_types,
            'escape' => false,
            'type' => 'radio',
            'legend' => false,
            'separator' => '<p>',
            'before' => '<p>',
            'default' => 1,
            'class' => 'gtype',
            'templateVars' => [
                'div_id' => 'golf-type-div',
                'extra_div_classes' => 'full-labels'
            ],
        ]);
        ?>

        <?php
        echo $this->Form->control('heard_about', [
            'options' => $heard,
            'label' => 'Where did you hear about the Golf Day?',
            'empty' => 'Please select...',
            'data-unhide-div' => "#heard-about-other-div",
            'data-unhide-text' => 'Other',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control('heard_about_other', [
            'label' => 'Other place you heard about the Golf Day',
            'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => "heard-about-other-div"],
        ]);
        ?>
    </fieldset>
    <?php for ($i = 0; $i < 4; $i++) { ?>
    <fieldset <?php if ($i > 0) {
        echo 'class="player_fieldset p' . ($i + 1) . ' hidden"';
    } ?>>
        <h2>Player <?php echo $i + 1; ?> details</h2>
        <?php if ($i > 0) { ?>
        <p><button class="copy-player-button" type="button" data-player="<?php echo $i; ?>">Copy player 1 details</button></p>
        <?php } ?>
        <?php
        echo $this->Form->control("golf_players.{$i}.id", ['type' => 'hidden']);
        echo $this->Form->control("golf_players.{$i}.title_id", [
            'data-unhide-div' => "#title-other-div-p{$i}",
            'data-unhide-text' => 'Other',
        ]);
        echo $this->Form->control("golf_players.{$i}.title_other", [
            'label' => 'Your title',
            'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => "title-other-div-p{$i}"],
        ]);

        echo $this->Form->control("golf_players.{$i}.first_name", [
            'label' => 'First name',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control("golf_players.{$i}.surname", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Surname',
        ]);
        echo $this->Form->control("golf_players.{$i}.organisation", ['label' => 'Organisation (if applicable)']);
        echo $this->Form->control("golf_players.{$i}.address_1", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Address 1',
        ]);
        echo $this->Form->control("golf_players.{$i}.address_2", [
            'label' => 'Address 2',
        ]);
        echo $this->Form->control("golf_players.{$i}.city", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Town or city',
        ]);
        echo $this->Form->control("golf_players.{$i}.county", [
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'County',
        ]);
        echo $this->Form->control("golf_players.{$i}.postal_code", [
            'label' => 'Postcode',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control("golf_players.{$i}.country_id", ['default' => 77]);
        echo $this->Form->control("golf_players.{$i}.telephone", [
            'type' => 'text',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
            'label' => 'Telephone',
        ]);
        echo $this->Form->control("golf_players.{$i}.mobile_phone", ['label' => 'Mobile']);
        echo $this->Form->control("golf_players.{$i}.email", [
            'label' => 'Email address',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control("golf_players.{$i}.email_confirm", [
            'label' => 'Confirm your email address',
            'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        ]);
        echo $this->Form->control("golf_players.{$i}.dietary_requirements", [
            'label' => 'Any special dietary requirements',
        ]);
        ?>
        <p>Martha Trust would like to keep you updated on our future news, fundraising activities and ways to support
            us. To opt in to receiving information from Martha Trust, please tick how you would prefer to be contacted:
        </p>
        <?php
        echo $this->Form->control("golf_players.{$i}.optin_email", ['label' => 'Email']);
        echo $this->Form->control("golf_players.{$i}.optin_telephone", [
            'label' => 'Telephone',
        ]);
        echo $this->Form->control("golf_players.{$i}.optin_letter", [
            'label' => 'Letter',
        ]);
        ?>
        <p>or email <a href="mailto:fundraising@marthatrust.org.uk">fundraising@marthatrust.org.uk</a>.</p>
        <p>We do not sell or swap your details with any third parties, but in order to carry out our work we may need to
            pass your details to services companies authorised to act on our behalf.</p>
    </fieldset>
    <?php } ?>
    <h2>Sponsorshop options</h2>

    <p><?php echo $golf_settings->sponsorship_blurb; ?></p>
    <ul>
        <?php foreach ($sponsorships as $sponsorship) { ?>
            <li><?php echo $sponsorship; ?></li>
        <?php } ?>
    </ul>

    <fieldset>
        <?php echo $this->Recaptcha->display(); ?>
    </fieldset>

    <button type="button" id="golf-submit-button">Submit</button>
    <?php echo $this->Form->end(); ?>
</div>

<div id="types" class="hidden">
    <?php echo json_encode($gtypes); ?>
</div>

<?php echo $this->Html->script(['https://code.jquery.com/jquery-3.7.1.min.js', 'application.js']); ?>
<?php echo $this->Html->css(['forms.css']);