<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Order $order
 */

use Cake\Core\Configure; ?>

<h1>Confirm your details</h1>

<?php $this->assign('title', 'Confirm the details of your registration'); ?>
<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
<p>Your payment will be handled safely and securely online by our payment provider SagePay.</p>
</div>',
); ?>

<p>Please check the details below to be sure they are correct. If you would like to change anything, you can
    <?php echo $this->Html->link('go back and make changes', [
        'action' => 'shop',
    ]); ?>.
</p>

<table width="90%">
    <tr>
        <td colspan="100%"><strong>Your order details</strong></td>
    </tr>
    <tr>
        <td>Item</td>
        <td>Price</td>
        <td>Quantity</td>
        <td>Sub-total</td>
    </tr>
    <?php foreach ($order->order_items as $i) {
        if ($i->quantity > 0) { ?>
    <tr>
        <td><?php echo $i->product->name; ?></td>
        <td>&pound;<?php echo number_format($i->price, 2); ?></td>
        <td><?php echo $i->quantity; ?></td>
        <td>&pound;<?php echo number_format($i->quantity * $i->price, 2); ?></td>
    </tr>
    <?php }
    } ?>
    <tr>
        <td colspan="3">TOTAL:</td>
        <td>&pound;<?php echo number_format($order->orderTotal(), 2); ?></td>
    </tr>
    <tr>
        <td colspan="3">Delivery</td>
        <td>&pound;<?php echo number_format($order->deliveryTotal(), 2); ?></td>
    </tr>
    <tr>
        <td colspan="3"><strong>GRAND TOTAL:</strong></td>
        <td><strong>&pound;<?php echo number_format($order->grandTotal(), 2); ?></strong></td>
    </tr>
</table>
<table width="90%">
    <tr>
        <td colspan="100%"><strong>Billing details</strong></td>
    </tr>

    <tr>
        <td width="40%">Title</td>
        <td><?php echo $order->title->name; ?></td>
    </tr>
    <?php if ($order->title->name === 'Other') { ?>
    <tr>
        <td>Title (if Other)</td>
        <td><?php echo $order->title_other; ?></td>
    </tr>
    <?php } ?>
    <tr>
        <td>First name</td>
        <td><?php echo $order->first_name; ?></td>
    </tr>
    <tr>
        <td>Surname</td>
        <td><?php echo $order->surname; ?></td>
    </tr>
    <tr>
        <td>Address 1</td>
        <td><?php echo $order->address_1; ?></td>
    </tr>
    <tr>
        <td>Address 2</td>
        <td><?php echo $order->address_2; ?></td>
    </tr>
    <tr>
        <td>City</td>
        <td><?php echo $order->city; ?></td>
    </tr>
    <tr>
        <td>Postcode</td>
        <td><?php echo $order->postal_code; ?></td>
    </tr>
    <tr>
        <td>Country</td>
        <td><?php echo $order->country->name; ?></td>
    </tr>

    <tr>
        <td>Telephone</td>
        <td><?php echo $order->telephone; ?></td>
    </tr>
    <tr>
        <td>Mobile phone</td>
        <td><?php echo $order->mobile_phone; ?></td>
    </tr>
    <tr>
        <td>Email address</td>
        <td><?php echo $order->email; ?></td>
    </tr>
    <tr>
        <td>Contact by email</td>
        <td><?php echo $order->optin_email ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Contact by telephone</td>
        <td><?php echo $order->optin_telephone ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Contact by letter</td>
        <td><?php echo $order->optin_letter ? 'Yes' : 'No'; ?></td>
    </tr>

</table>
<table width="90%">
    <tr>
        <td colspan="100%"><strong>Delivery details</strong></td>
    </tr>

    <tr>
        <td width="40%">Title</td>
        <td><?php echo $order->delivery_title->name; ?></td>
    </tr>
    <?php if ($order->delivery_title->name === 'Other') { ?>
    <tr>
        <td>Title (if Other)</td>
        <td><?php echo $order->delivery_title_other; ?></td>
    </tr>
    <?php } ?>

    <tr>
        <td>First name</td>
        <td><?php echo $order->d_first_name; ?></td>
    </tr>
    <tr>
        <td>Surname</td>
        <td><?php echo $order->d_surname; ?></td>
    </tr>
    <tr>
        <td>Address 1</td>
        <td><?php echo $order->d_address_1; ?></td>
    </tr>
    <tr>
        <td>Address 2</td>
        <td><?php echo $order->d_address_2; ?></td>
    </tr>
    <tr>
        <td>City</td>
        <td><?php echo $order->d_city; ?></td>
    </tr>
    <tr>
        <td>Postcode</td>
        <td><?php echo $order->d_postal_code; ?></td>
    </tr>
    <tr>
        <td>Country</td>
        <td><?php echo $order->delivery_country->name; ?></td>
    </tr>

</table>

<p>If you're happy with your purchase details, please click Proceed to continue with your registration: </p>
<p>
<form action="<?php echo $sagepay_url; ?>" method="POST" id="SagePayForm" name="SagePayForm">
    <input type="hidden" name="VPSProtocol" value="3.00">
    <input type="hidden" name="TxType" value="PAYMENT">
    <input type="hidden" name="Vendor" value="<?php echo Configure::read('Forms.SagePay.vendor_name'); ?>">
    <input type="hidden" name="Crypt" value="<?php echo $crypted; ?>">
    <input type="submit" value="Proceed to payment" />
</form>
</p>