<?php use Cake\Core\Configure; ?>

<h1>Confirm your registration</h1>

<?php $this->assign('title', 'Confirm the details of your registration'); ?>
<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Payment for your registration will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
); ?>

<p>
    Please check the details below to be sure they are correct. If you would like to change anything, you can 
    <?php echo $this->Html->link('go back and make changes', ['action' => 'register']); ?>.
</p>

<table>
    <tr>
        <td>Event</td>
        <td><?php echo $registration->event->name; ?></td>
    </tr>
    <tr>
        <td>Tickets</td>
        <td>
            <table style="margin-left:0; margin-right:0; border:1px solid #cccccc;">
                <tr>
                    <td style="border-right:1px solid #cccccc;">Type</td>
                    <td style="border-right:1px solid #cccccc;">Price</td>
                    <td style="border-right:1px solid #cccccc;">Amount</td>
                    <td>Sub-total</td>
                </tr>
                <?php foreach ($registration->tickets as $t) { ?>
                <tr>
                    <td style="border-right:1px solid #cccccc;"><?php echo $t->event_cost->name; ?></td>
                    <td style="border-right:1px solid #cccccc;" align="right">&pound;<?php echo $t->event_cost->price; ?></td>
                    <td style="border-right:1px solid #cccccc;"><?php echo $t->amount; ?></td>
                    <td align="right">&pound;<?php echo number_format($t->amount * $t->event_cost->price, 2); ?>
                    </td>



                </tr>
                <?php } ?>
            </table>
        </td>
    </tr>
    <tr>
        <td>Cost</td>
        <td>&pound;<?php echo number_format($registration->grandTotal(), 2); ?> </td>
    </tr>
    <tr>
        <td>Title</td>
        <td><?php echo $registration->title->name; ?></td>
    </tr>
    <?php if ($registration->title_name == 'Other') { ?>
    <tr>
        <td>Title (if Other)</td>
        <td><?php echo $registration->title_other; ?></td>
    </tr>
    <?php } ?>

    <tr>
        <td>First name</td>
        <td><?php echo $registration->first_name; ?></td>
    </tr>
    <tr>
        <td>Surname</td>
        <td><?php echo $registration->surname; ?></td>
    </tr>
    <?php if ($registration->event->dob_on) { ?>
    <tr>
        <td>Date of birth</td>
        <td><?php echo date('d M Y', strtotime($registration->date_of_birth)); ?></td>
    </tr>
    <?php } ?>
    <tr>
        <td>Organisation</td>
        <td><?php echo $registration->organisation; ?></td>
    </tr>
    <tr>
        <td>Address 1</td>
        <td><?php echo $registration->address_1; ?></td>
    </tr>
    <tr>
        <td>Address 2</td>
        <td><?php echo $registration->address_2; ?></td>
    </tr>
    <tr>
        <td>City</td>
        <td><?php echo $registration->city; ?></td>
    </tr>
    <tr>
        <td>Postcode</td>
        <td><?php echo $registration->postal_code; ?></td>
    </tr>
    <tr>
        <td>Country</td>
        <td><?php echo $registration->country->name; ?></td>
    </tr>
    <?php if ($registration->country_name == 'United States') { ?>
    <tr>
        <td>State code</td>
        <td><?php echo $registration->state_code; ?></td>
    </tr>
    <?php } ?>
    <tr>
        <td>Email address</td>
        <td><?php echo $registration->email; ?></td>
    </tr>
    <tr>
        <td>Telephone</td>
        <td><?php echo $registration->telephone; ?></td>
    </tr>
    <tr>
        <td>Mobile</td>
        <td><?php echo $registration->mobile; ?></td>
    </tr>
    <tr>
        <td>Receive email?</td>
        <td><?php echo $registration->optin_email ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Receive phonecalls?</td>
        <td><?php echo $registration->optin_telephone ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Receive letters?</td>
        <td><?php echo $registration->optin_letter ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Heard about</td>
        <td><?php echo $registration->heard_about; ?></td>
    </tr>
    <?php if ($registration->heard_about == 'Other') { ?>
    <tr>
        <td>Heard about other</td>
        <td><?php echo $registration->heard_about_other; ?></td>
    </tr>
    <?php } ?>
    <?php if ($registration->emergency_contact_on) { ?>
    <tr>
        <td>Emergency contact</td>
        <td><?php echo $registration->emergency_contact; ?></td>
    </tr>
    <tr>
        <td>Emergency contact number</td>
        <td><?php echo $registration->emergency_contact_number; ?></td>
    </tr>
    <tr>
        <td>Medical conditions </td>
        <td><?php echo $registration->medical_conditions; ?></td>
    </tr>
    <?php } ?>

    <?php if (!empty($registration->event->custom_field_1)) { ?>
    <tr>
        <td><?php echo $registration->event->custom_field_1; ?></td>
        <td><?php echo $registration->custom_field_1; ?></td>
    </tr>
    <?php } ?>
    <?php if (!empty($registration->event->custom_field_2)) { ?>
    <tr>
        <td><?php echo $registration->event->custom_field_2; ?></td>
        <td><?php echo $registration->custom_field_2; ?></td>
    </tr>
    <?php } ?>
</table>

<p>If you're happy with your registration details, please click Proceed to continue with your donation: </p>
<p>
<form action="<?php echo $sagepay_url; ?>" method="POST" id="SagePayForm" name="SagePayForm">
    <input type="hidden" name="VPSProtocol" value="3.00">
    <input type="hidden" name="TxType" value="PAYMENT">
    <input type="hidden" name="Vendor" value="<?php echo Configure::read('Forms.SagePay.vendor_name'); ?>">
    <input type="hidden" name="Crypt" value="<?php echo $crypted; ?>">
    <input type="submit" value="Proceed to payment" />
</form>
</p>