<?php
// echo $this->Html->script('https://www.google.com/recaptcha/api.js', ['inline' => true]);
// $google_captcha_key = Configure::read('googleCaptcha.Google.site-key');
?>

<?php $this->Form->setTemplates([
    'inputContainer' =>
        '<div id="{{div_id}}" class="input {{type}}{{required}} {{extra_div_classes}}">{{before}} {{content}} {{after}}</div>',
    'input' => '{{between}} <input type="{{type}}" name="{{name}}"{{attrs}}/>',
]); ?>

<?php
$this->assign('title', 'Event registration form');
$this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your payment will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
);

$ages = ['16 or over' => '16 or over (&pound;15)', '11 - 15' => '11 - 15 (&pound;7.50)'];
$heard = [
    'Colleague' => 'Colleague',
    'Facebook' => 'Facebook',
    'Friends and Family' => 'Friends and Family',
    'Letter' => 'Letter',
    'Martha News' => 'Martha News',
    'Newspaper' => 'Newspaper',
    'Search engine' => 'Search engine',
    'Twitter' => 'Twitter',
    'Other' => 'Other',
];
$reason = [
    'In memory of a loved one' => 'In memory of a loved one',
    'A personal challenge' => 'A personal challenge',
    'To raise money' => 'To raise money',
    'Other' => 'Other (please specify below)',
];
$tickets = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
?>

<?php if ($registration && $registration->tickets) { ?>
<div id="tickets" class="hidden">
    <?php echo json_encode($registration->tickets); ?>
</div>
<?php } ?>
<div class="registrations form">
    <?php echo $this->Form->create($registration); ?>

    <h1><?php __('Event registration form'); ?></h1>
    <p>Thank you for choosing to register for a Martha event! To register, please complete the form below.</p>
    <fieldset>
        <h2>Your chosen event</h2>
        <?php
        echo $this->Form->control('id');
        echo $this->Form->control('event_cost_id', ['type' => 'hidden', 'rel' => 'hidden_cost']);
        echo $this->Form->control('part_reasons_on', ['type' => 'hidden', 'value' => false]);
        echo $this->Form->control('emergency_contact_on', ['type' => 'hidden', 'value' => false]);
        echo $this->Form->control('event_id', [
            'empty' => 'Please select..',
            'data-url' => $this->Html->Url->build(['action' => 'get_event_costs']),
            'label' => 'Please select the event you want to register for',
        ]);
        echo $this->Html->image('ajax-loader.gif', ['id' => 'ajax', 'class' => 'hidden']);
        ?>
        <div id="cost_container">
        </div>
    </fieldset>
    <?php echo $this->Form->control('additional_guests', [
        'templateVars' => [
            'extra_div_classes' => 'hidden',
            'div_id' => 'additional_guests_container',
        ],
    ]); ?>
    <fieldset id="dob-details" class="hidden">
        <legend>Date of Birth</legend>
        <?php echo $this->Form->control('date_of_birth', [
            'label' => 'Your date of birth',
            'empty' => 'Select...',
            'dateFormat' => 'DMY',
            'minYear' => 1910,
            'maxYear' => 1998,
            'after' => '<span class="instructions">(required)</span>',
        ]); ?>
    </fieldset>
    <fieldset>
        <h2>Your details</h2>
        <?php
        echo $this->Form->control('title_id', [
            'data-unhide-div' => '#title-other-div',
            'data-unhide-text' => 'Other',
        ]);
        echo $this->Form->control('title_other', [
            'label' => 'Your title',
            'templateVars' => [
                'extra_div_classes' => 'hidden',
                'div_id' => 'title-other-div',
            ],
        ]);
        echo $this->Form->control('first_name', [
            'label' => 'First name',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('surname', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);

        echo $this->Form->control('organisation', [
            'label' => 'Organisation',
            'templateVars' => [
                'after' => '<span class="instructions">(if applicable)</span>',
            ],
        ]);
        echo $this->Form->control('address_1', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('address_2');
        echo $this->Form->control('city', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
            'label' => 'Town or city',
        ]);
        echo $this->Form->control('county', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('postal_code', [
            'label' => 'Postcode',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('country_id', [
            'default' => 77,
            'data-unhide-text' => 'United States',
            'data-unhide-div' => '#state-code-div',
        ]);
        ?>
    </fieldset>
    <fieldset>
        <h2>Contact details</h2>
        <?php
        echo $this->Form->control('telephone', [
            'type' => 'text',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('mobile');
        echo $this->Form->control('email', [
            'label' => 'Email address',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('email_confirm', [
            'label' => 'Confirm your email address',
            'templateVars' => [
                'after' => ' <span class="instructions">(required)</span>',
            ],
        ]);
        ?>
        <p>Martha Trust would like to keep you updated on our future news, fundraising activities and ways to support
            us. To opt in to receiving information from Martha Trust, please tick how you would prefer to be contacted:
        </p>
        <?php
        echo $this->Form->control('optin_email', ['label' => 'Email']);
        echo $this->Form->control('optin_telephone', ['label' => 'Telephone']);
        echo $this->Form->control('optin_letter', ['label' => 'Letter']);
        ?>
        <p>or email <a href="mailto:fundraising@marthatrust.org.uk">fundraising@marthatrust.org.uk</a>.</p>
        <p>We do not sell or swap your details with any third parties, but in order to carry out our work we may need to
            pass your details to services companies authorised to act on our behalf.</p>
        <?php
        echo $this->Form->control('heard_about', [
            'options' => $heard,
            'label' => 'Where did you hear about this event?',
            'templateVars' => [
                'after' => ' <span class="instructions">(required)</span>',
            ],
            'empty' => 'Please select...',
            'data-unhide-div' => '#heard-about-other-div',
            'data-unhide-text' => 'Other',
        ]);
        echo $this->Form->control('heard_about_other', [
            'label' => 'Other place you heard about this event',
            'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => 'heard-about-other-div'],
        ]);
        ?>
    </fieldset>
    <fieldset id="emergency_contact" class="hidden">
        <h2>Emergency contact details</h2>
        <?php
        echo $this->Form->control('emergency_contact', [
            'label' => 'Emergency contact name',
            'templateVars' => [
                'after' => ' <span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('emergency_contact_number', [
            'label' => 'Emergency contact number',
            'templateVars' => [
                'after' => ' <span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('medical_conditions', [
            'label' => 'Please advise us of any medical conditions you have',
        ]);
        ?>
    </fieldset>
    <fieldset class="hidden" id="custom_field_container">
        <h2>Other questions</h2>
        <?php
        echo $this->Form->control('custom_field_1', [
            'div' => [
                'id' => 'custom_field_1',
            ],
        ]);
        echo $this->Form->control('custom_field_2', [
            'div' => [
                'id' => 'custom_field_2',
            ],
        ]);
        ?>
    </fieldset>
    <fieldset id="terms-conditions" class="hidden">
        <legend>Terms and conditions</legend>
        <?php echo $this->Form->control('disclaimer', [
            'label' => 'I have read and agree to the terms and conditions',
            'required' => true,
        ]); ?>
    </fieldset>
    <fieldset>
        <?php echo $this->Recaptcha->display(); ?>
    </fieldset>
    <?php echo $this->Form->button(__('Submit')); ?>
    <?php echo $this->Form->end(); ?>
</div>
<?php echo $this->Html->script([
    'https://code.jquery.com/jquery-3.7.1.min.js',
    'handlebars.js',
    'application.js',
    'registrations.js',
]); ?>
<?php echo $this->Html->css(['forms.css']); ?>

<div id="template-single" class="hidden">
    <input type="hidden" name="tickets[0][amount]" value="1">
    {{#costs}}
    <input type="radio" name="tickets[0][event_cost_id][]" class="cost_radios" value="{{id}}" checked>{{name}} -
    &pound;{{price}}<br />
    {{/costs}}
</div>
<div id="template-multiple" class="hidden">
    {{#costs}}
    <select name="tickets[{{@index}}][amount]" id="ecost_{{id}}">
        {{#each tickets_available}}
        <option value="{{this}}">{{this}}</option>
        {{/each}}
    </select>
    <input type="hidden" name="tickets[{{@index}}][event_cost_id]" value="{{id}}">
    {{name}} at &pound;{{price}}
    {{#if sold_out }}
        <span class="sold_out">SOLD OUT</span>
    {{/if}}
    <br />
    {{/costs}}
    <?php
//echo $this->Form->select('tickets', $tickets, [ 'type' => 'select', 'options' => $tickets, 'name' => 'tickets[{{@index}}][amount]', 'id' => 'ecost_{{id}}', 'div' => false, 'label' => false, ]);
?>
</div>