<?php $this->title_for_layout = 'Thank you for your registration!'; ?>
<?php $this->content_for_right = '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
<p>Payment for your registration will be handled safely and securely online by our payment provider SagePay.</p>
</div>'; ?>
<?php //  debug($decoded);

if ($decoded['Status'] == 'OK') { ?>
<h1>Your payment was successful!</h1>
<div id="details">
    <table>
        <tr>
            <td colspan="100%">
                Thank you for your registration payment! You will receive an email with your registration details
                shortly, which were as follows:
            </td>
        </tr>
        <tr>
            <td>Amount paid</td>
            <td>&pound;<?php echo $registration->grandTotal(); ?></td>
        </tr>
        <tr>
            <td>Transaction reference code:</td>
            <td>
                <?php echo $decoded['VendorTxCode']; ?>
            </td>
        </tr>
        <tr>
            <td>Event</td>
            <td><?php echo $registration->event->name; ?></td>
        </tr>
        <tr>
            <td>Tickets</td>
            <td>
                <table style="margin-left:0; margin-right:0; border:1px solid #cccccc;">
                    <tr>
                        <td style="border-right:1px solid #cccccc;">Type</td>
                        <td style="border-right:1px solid #cccccc;">Price</td>
                        <td style="border-right:1px solid #cccccc;">Amount</td>
                        <td>Sub-total</td>
                    </tr>
                    <?php foreach ($registration->tickets as $t) { ?>
                    <tr>
                        <td style="border-right:1px solid #cccccc;"><?php echo $t->event_cost->name; ?></td>
                        <td style="border-right:1px solid #cccccc;" align="right">
                            &pound;<?php echo $t->event_cost->price; ?></td>
                        <td style="border-right:1px solid #cccccc;"><?php echo $t->amount; ?></td>
                        <td align="right">&pound;<?php echo $t->amount * $t->event_cost->price; ?></td>
                    </tr>
                    <?php } ?>
                </table>
            </td>
        </tr>
        <tr>
            <td>Cost</td>
            <td>&pound;<?php echo $this->Number->format($registration->grandTotal(), ['places' => 2]); ?> </td>
        </tr>
        <tr>
            <td>Title</td>
            <td><?php echo $registration->title->name; ?></td>
        </tr>
        <?php if ($registration->title->name == 'Other') { ?>
        <tr>
            <td>Title (if Other)</td>
            <td><?php echo $registration->title_other; ?></td>
        </tr>
        <?php } ?>

        <tr>
            <td>First name</td>
            <td><?php echo $registration->first_name; ?></td>
        </tr>
        <tr>
            <td>Surname</td>
            <td><?php echo $registration->surname; ?></td>
        </tr>
        <?php if ($registration->event->dob_on) { ?>
        <tr>
            <td>Date of Birth</td>
            <td><?php echo date('d M Y', strtotime($registration->date_of_birth)); ?></td>
        </tr>
        <?php } ?>
        <tr>
            <td>Organisation</td>
            <td><?php echo $registration->organisation; ?></td>
        </tr>
        <tr>
            <td>Address 1</td>
            <td><?php echo $registration->address_1; ?></td>
        </tr>
        <tr>
            <td>Address 2</td>
            <td><?php echo $registration->address_2; ?></td>
        </tr>
        <tr>
            <td>City</td>
            <td><?php echo $registration->city; ?></td>
        </tr>
        <tr>
            <td>Postcode</td>
            <td><?php echo $registration->postal_code; ?></td>
        </tr>
        <tr>
            <td>Country</td>
            <td><?php echo $registration->country->name; ?></td>
        </tr>
        <?php if ($registration->country->name == 'United States') { ?>
        <tr>
            <td>State code</td>
            <td><?php echo $registration->state_code; ?></td>
        </tr>
        <?php } ?>
        <tr>
            <td>Email address</td>
            <td><?php echo $registration->email; ?></td>
        </tr>
        <tr>
            <td>Telephone</td>
            <td><?php echo $registration->telephone; ?></td>
        </tr>
        <tr>
            <td>Mobile</td>
            <td><?php echo $registration->mobile; ?></td>
        </tr>
        <tr>
            <td>Receive email?</td>
            <td><?php echo $registration->no_email ? 'Yes' : 'No'; ?></td>
        </tr>
        <tr>
            <td>Receive phonecalls?</td>
            <td><?php echo $registration->no_telephone ? 'Yes' : 'No'; ?></td>
        </tr>
        <tr>
            <td>Receive letters?</td>
            <td><?php echo $registration->no_letter ? 'Yes' : 'No'; ?></td>
        </tr>
        <?php if ($registration->event->emergency_contact_on) { ?>
        <tr>
            <td>Emergency contact</td>
            <td><?php echo $registration->emergency_contact; ?></td>
        </tr>
        <tr>
            <td>Emergency contact number</td>
            <td><?php echo $registration->emergency_contact_number; ?></td>
        </tr>
        <tr>
            <td>Medical Conditions </td>
            <td><?php echo $registration->medical_conditions; ?></td>
        </tr>
        <?php } ?>

        <?php if (!empty($registration->event->custom_field_1)) { ?>
        <tr>
            <td><?php echo $registration->event->custom_field_1; ?></td>
            <td><?php echo $registration->custom_field_1; ?></td>
        </tr>
        <?php } ?>
        <?php if (!empty($registration->event->custom_field_2)) { ?>
        <tr>
            <td><?php echo $registration->event->custom_field_2; ?></td>
            <td><?php echo $registration->custom_field_2; ?></td>
        </tr>
        <?php } ?>
    </table>

    <p><a href="/" title="Go back to the Martha Trust homepage">Go back to the Martha Trust homepage >></a></p>
</div>
<?php } else { ?>
<h3>Your payment was unsuccessful</h3>
<p>Your payment was not authorised. Reason: <strong><?php echo $decoded['StatusDetail']; ?></strong></p>
<p>
    If you would like to re-attempt the transaction, please
    <?php echo $this->Html->link('click here', ['action' => 'confirm']); ?>
</p>
<?php } ?>