jQuery(function () {
    // Cars form

    var parts = $('fieldset.participants');
    var terms = $('div.terms');
    var terms_checkboxes = $('.terms-checkbox');

    $('#team-number')
        .change(function () {
            terms_checkboxes.data('required', false);
            parts.hide();
            terms.hide();

            for (var i = 0; i < parseInt($(this).val()); i++) {
                $('#part_' + i).show();
                $(`.tcs${i + 1}`)
                    .show()
                    .find('input')
                    .data('required', true);
            }
            $('.title_select').trigger('change');
        })
        .trigger('change');

    $('#cars-submit-button').on('click', function (e) {
        var submit = true;
        $('[type="checkbox"][name*="agree"],[type="checkbox"][name*="tcs"]').each(function () {
            if ($(this).data('required') && !$(this).is(':checked')) {
                submit = false;
            }
        });

        if (!submit) {
            e.preventDefault();
            alert('You must agree to the terms and conditions at the start and end of the form');
        } else {
            $('#cars-registration-form').submit();
        }
    });

    // Golf form
    if ($('#types').length > 0) {
        var gtypes = $.parseJSON($('#types').html());
    }

    $('input.gtype').change(function () {
        var n = gtypes[$(this).val()];
        $('fieldset.player_fieldset').hide();
        for (var i = 2; i <= n; i++) {
            $('fieldset.p' + i).show();
        }
        $('.title_select').trigger('change');
    });
    $('input.gtype:checked').trigger('change');

    $('.copy-player-button').on('click', function (e) {
        e.preventDefault();
        var n = $(this).data('player');
        $(
            `input[type!="hidden"][name*="golf_players[${n}]"],textarea[name*="golf_players[${n}]"],select[name*="golf_players[${n}]"]`
        ).each(function () {
            var name = $(this).attr('name');
            name = name.replace(`[${n}]`, '[0]');
            $(this).val($(`[name="${name}"]`).val());
        });
    });

    $('#golf-submit-button').on('click', function (e) {
        var n = gtypes[$('input.gtype:checked').val()];
        console.log(n);
        $c = 0;
        $('fieldset.player_fieldset').each(function () {
            $c++;
            if ($c + 1 > n) {
                $(this).remove();
            }
        });
        $('#golf-registration-form').submit();
    });

    // Donations form
    jQuery('button.amount-button').click(function () {
        jQuery('#donation-amount').val(jQuery(this).data('amount'));
    });

    jQuery('#copy-details-check').click(function () {
        if (jQuery(this).is(':checked')) {
            jQuery('[data-copy]').each(function () {
                var target = jQuery(this).data('copy');
                jQuery(this).val(jQuery(target).val());
            });
        } else {
            jQuery('[data-copy]').val('');
        }
    });

    jQuery('#CycleWhichRoute')
        .change(function () {
            if (jQuery(this).val() == 'Family ride - 8 miles') {
                jQuery('#CycleStartingPoint').val('Canterbury').parent().slideUp();
            } else {
                jQuery('#CycleStartingPoint').val('').parent().slideDown();
            }
        })
        .trigger('change');

    jQuery('#MoonlightTitleId').find('option[value=1]').remove();
    jQuery('#MoonlightTshirtWant').click(function () {
        check_tshirt();
    });
    jQuery('#StarlightTshirtWant').click(function () {
        check_tshirt_star();
    });

    jQuery('[data-unhide-text]')
        .change(function () {
            var next = jQuery(this).data('unhide-div');
            if (jQuery(this).find(':selected').text() === jQuery(this).data('unhide-text')) {
                jQuery(next).slideDown();
            } else {
                jQuery(next).slideUp();
            }
        })
        .trigger('change');

    jQuery(
        '#CycleHeardAbout, #CyclePartReason, #MoonlightHeardAbout, #MoonlightPartReason, #StarlightHeardAbout, #StarlightPartReason'
    )
        .change(function () {
            if (jQuery(this).find(':selected').val() == 'Other') jQuery('#' + this.id + 'OtherDiv').slideDown();
            else jQuery('#' + this.id + 'OtherDiv').slideUp();
        })
        .trigger('change');

    jQuery('#MoonlightPartReason,#StarlightPartReason').change(function () {
        moon_loved();
    });

    function moon_loved() {
        if (jQuery('#MoonlightPartReason,#StarlightPartReason').find(':selected').val() == 'In memory of a loved one') {
            jQuery('#part_memory_name').slideDown();
        } else {
            jQuery('#part_memory_name').slideUp();
        }
    }

    jQuery('#MoonlightShirtOrScarf')
        .change(function () {
            if (jQuery(this).val() == 'T-shirt') {
                jQuery('#size_field').slideDown();
            } else {
                jQuery('#size_field').slideUp();
            }
        })
        .trigger('change');

    jQuery('#CyclePartMemory').click(partMemory);
    jQuery('#MoonlightPartMemory').click(partMemoryMoon);

    jQuery('#VoucherRecTitleId').change(function () {
        if (jQuery(this).find(':selected').text() == 'Other') jQuery('#rec_title_other').slideDown();
        else jQuery('#rec_title_other').slideUp();
    });

    jQuery('#reason-id').change(function () {
        if (jQuery(this).find(':selected').text() == 'Fundraising') {
            jQuery('#reason_event').slideDown();
            jQuery('#reason_memo').slideUp();
        } else {
            jQuery('#reason_memo').slideDown();
            jQuery('#reason_event').slideUp();
        }
    });
    jQuery('#VoucherVoucherType').change(function () {
        if (jQuery(this).find(':selected').text() == 'Any occasion') jQuery('#voucher_type_other').slideDown();
        else jQuery('#voucher_type_other').slideUp();
    });
    jQuery('#LotteryExistingPlayer').change(function () {
        if (jQuery(this).attr('checked')) jQuery('#membership_number').slideDown();
        else jQuery('#membership_number').slideUp();
    });
    jQuery('#LotteryJoinWeeks').change(function () {
        calc_total();
    });

    jQuery('#BookingCourseId').change(function () {
        $.ajax({
            url: q_url + '/' + jQuery(this).val() + '/' + date_selected,
            success: function (data) {
                jQuery('#course_dates').html(data);
            },
            error: function () {
                alert('Error communicating with server, please retry');
            },
            complete: function () {
                jQuery('#ajax_loader').remove();
            },
            beforeSend: function () {
                jQuery('#course_dates').html(aj_img);
            },
        });
    });

    jQuery('#BookingIsPct').on('click', function () {
        check_pct();
    });
    jQuery('input[rel=pay_methods]').click(function () {
        if (jQuery(this).attr('value') == 'IN') {
            jQuery('#invoice_details').slideDown();
        } else {
            jQuery('#invoice_details').slideUp();
        }
    });

    jQuery('#LotteryNumberOfEntries').keyup(function () {
        calc_total();
    });

    check_pct();
    partMemory();
    partMemoryMoon();
    check_tshirt();
    moon_loved();
});
function partMemoryMoon() {
    if (jQuery('#MoonlightPartMemory').attr('checked')) jQuery('#part_memory_name').slideDown();
    else jQuery('#part_memory_name').slideUp();
}

function partMemory() {
    if (jQuery('#CyclePartMemory').attr('checked')) jQuery('#part_memory_name').slideDown();
    else jQuery('#part_memory_name').slideUp();
}

function calc_total() {
    if (jQuery('#LotteryNumberOfEntries').val() != '') {
        var total = parseInt(jQuery('#LotteryJoinWeeks').val()) * parseInt(jQuery('#LotteryNumberOfEntries').val());
        jQuery('#LotteryCalcAmount').val(total);
    }
}
function check_pct() {
    if (jQuery('#BookingIsPct').attr('checked')) jQuery('#payment_details').slideUp();
    else jQuery('#payment_details').slideDown();
}
function check_tshirt() {
    if (jQuery('#MoonlightTshirtWant').attr('checked')) {
        jQuery('#tshirt_fields').slideDown();
    } else {
        jQuery('#tshirt_fields').slideUp();
    }
}
function check_tshirt_star() {
    if (jQuery('#StarlightTshirtWant').attr('checked')) {
        jQuery('#tshirt_fields').slideDown();
    } else {
        jQuery('#tshirt_fields').slideUp();
    }
}
