$(function () {
    var dob_details = $('#dob-details');
    var terms_details = $('#terms-conditions');
    $('#event-id').change(function () {
        if ($(this).val() != '') {
            $.ajax({
                url: $(this).attr('data-url') + '/' + $(this).val(),
                type: 'POST',
                data: {
                    _csrfToken: $('input[name=_csrfToken]').val(),
                },
                dataType: 'json',
                beforeSend: function () {
                    $('#ajax').show();
                },
                complete: function () {
                    $('#ajax').hide();
                },
                success: function (data) {
                    var template = data.multiple_tickets ? '#template-multiple' : '#template-single';
                    var compiled_template = Handlebars.compile($(template).html());
                    $('#cost_container').html(compiled_template(data));
                    if (data.multiple_tickets) $('#additional_guests_container').show();
                    else $('#additional_guests_container').hide();

                    if (data.dob) {
                        dob_details.find('p').remove();
                        dob_details
                            .show()
                            .find('legend')
                            .after('<p>' + data.dob_text + '</p>');
                    } else dob_details.hide();

                    if (data.terms) {
                        terms_details.find('p').remove();
                        terms_details
                            .show()
                            .find('legend')
                            .after('<p>' + data.terms_text + '</p>');
                    } else terms_details.hide();

                    $('#part-reasons-on').val(data.part_reasons ? 1 : 0);
                    $('#emergency-contact-on').val(data.emergency_contact ? 1 : 0);
                    if (data.part_reasons) $('#part_reasons').slideDown();
                    else $('#part_reasons').slideUp();
                    if (data.emergency_contact) $('#emergency_contact').slideDown();
                    else $('#emergency_contact').slideUp();
                    var cfields = $('#custom_field_container');
                    if (data.custom_field_1 != '') {
                        $('#custom_field_1').find('label').html(data.custom_field_1);
                        cfields.show();
                    } else {
                        cfields.hide();
                    }
                    if (data.custom_field_2 == '') {
                        $('#custom_field_2').hide();
                    } else {
                        var field2 = $('#custom_field_2');
                        field2.find('label').html(data.custom_field_2);
                        field2.show();
                    }
                    chosen_tickets();
                },
                error: function () {
                    alert('Error communicating with server, please retry');
                },
            });
        } else {
            $('#cost_container').html('');
        }
    });
    $('#event-id').trigger('change');

    $('#part-reason').change(function () {
        registration_loved();
    });

    $('#RegistrationPartMemory').click(partMemoryregistration);

    $('#title-id').trigger('change');

    partMemoryregistration();
    registration_loved();
});

function chosen_tickets() {
    tick_info = $('#tickets');
    if (tick_info.length > 0) {
        tickets = $.parseJSON(tick_info.html());
        console.log(tickets);
        $.each(tickets, function (i, item) {
            $('#cost_container')
                .find('#ecost_' + item.event_cost_id)
                .val(item.amount);
        });
    }
}

function partMemoryregistration() {
    if ($('#RegistrationPartMemory').attr('checked')) $('#part_memory_name').slideDown();
    else $('#part_memory_name').slideUp();
}
function registration_loved() {
    if ($('#RegistrationPartReason').find(':selected').val() == 'In memory of a loved one')
        $('#part_memory_name').slideDown();
    else $('#part_memory_name').slideUp();
}
